<?php

namespace App\Http\Controllers\Admin\Academy;

use App\Http\Controllers\Controller;
use App\Models\Academy\academyType;
use App\Models\Academy\agent;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Illuminate\Validation\Rule;

class AcademyTypesController extends Controller
{
    public function index()
    {
        $this->authorize('academyType_index');

        if (request()->has('page')) {
            $list = academyType::search()->latest()->paginate();

            return response()->json($list);
        }

        return view('admin.Academy.type.index');
    }

    public function create()
    {
        $this->authorize('academyType_store');

        return view('admin.Academy.type.create');
    }

    public function store(Request $request)
    {
        $this->authorize('academyType_store');

        $this->validate($request, [
            'title' => 'required|string|min:1|max:256',
            'body' => 'required|string|min:1|max:4096',
            'picture' => 'nullable|image|mimes:jpeg,bmp,png|max:4096',
        ]);

        academyType::create([
            'title' => $request->input('title'),
            'body' => $request->input('body'),
            'picture' => storeFile('picture', 'academytypes'),
            'status' => $request->has('status'),
        ]);

        message();
        return redirect()->route('admin.academy.academytype.index');
    }

    public function show(academyType $academytype)
    {
        $this->authorize('academyType_show');

        return response()->json($academytype);
    }

    public function edit(academyType $academytype)
    {
        $this->authorize('academyType_update');

        return view('admin.Academy.type.edit', compact('academytype'));
    }

    public function update(Request $request, academyType $academytype)
    {
        $this->authorize('academyType_update');

        $this->validate($request, [
            'title' => 'required|string|min:1|max:256',
            'body' => 'required|string|min:1|max:4096',
            'picture' => 'nullable|image|mimes:jpeg,bmp,png|max:4096',
        ]);

        $academytype->update([
            'title' => $request->input('title'),
            'body' => $request->input('body'),
            'picture' => updateFile('picture', 'academytypes', $academytype->picture),
            'status' => $request->has('status'),
        ]);


        message('ویرایش شد.');
        return redirect()->route('admin.academy.academytype.edit', $academytype->id);
    }

    public function destroy(academyType $academytype)
    {
        $this->authorize('academyType_destroy');

        if ($academytype->picture) {
            Storage::delete($academytype->picture);
        }
        return response()->json($academytype->delete());
    }
}
