<?php

namespace App\Http\Controllers\Admin\Acl;

use App\Http\Controllers\Admin\exportExcel\UsersExport;
use App\Libraries\Rules\nationalCode;
use App\User;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Illuminate\Validation\Rule;
use Maatwebsite\Excel\Facades\Excel;

class userController extends Controller
{
    public function index()
    {
        $this->authorize('user_crud_index');

        if (request()->has('page')) {
            if (auth()->user()->userName == 'root') {
                $list = User::search()->latest('id')->with('serviceCard','referalOrganizion')->paginate();
            } else {
                $list = User::search()->where('userName', '<>', 'root')->with('serviceCard')->withCount('referalOrganizion')->latest('id')->paginate();
            }
            return response()->json($list);
        }

        return view('admin.users.index');
    }

    public function create()
    {
        $this->authorize('user_crud_store');

        return view('admin.users.create');
    }

    public function store(Request $request)
    {
        $this->authorize('user_crud_store');

        $request->offsetSet('birthday',toGorgian($request->input('birthday',null)));

        $this->validate($request, [
            'skill_id' => 'nullable|numeric|exists:skills,id',
            'city_id' => 'required|numeric|exists:cities,id',
            'roles_id.*' => [
                'required',
                Rule::exists('roles', 'id')->whereIn('id', auth()->user()->allRoles()->pluck('id')->toArray())
            ],

            'userName' => [
                'required',
                'string',
                'max:255',
                'unique:users,userName',
            ],

            'email' => 'nullable|email|string|min:3|max:255',
            'firstName' => 'required|string|max:255',
            'lastName' => 'required|string|max:255',
            'fatherName' => 'nullable|string|max:255',
            'gender' => 'required|in:male,female',
            'nationalCode' => ['nullable', 'numeric', new nationalCode()],
            'certificateCode' => 'nullable|string|min:1|max:11',
            'postalCode' => 'nullable|digits_between:9,11',
            'birthday' => 'required|before:2005-01-01',
            'birthplace' => 'required|string|min:4|max:255',
            'mobile' => 'nullable|numeric',
            'telephone' => 'nullable|numeric',
            'address' => 'nullable|string|min:4|max:2048',
            'education' => 'required|in:1,2,3,4,5,6',
            'fieldOfStudy' => 'required|string|min:4|max:255',

            'educationPicture' => 'nullable|image|mimes:jpeg,bmp,png|max:4096',
            'personalPicture' => 'nullable|image|mimes:jpeg,bmp,png|max:4096',
            'nationalCardPicture' => 'nullable|image|mimes:jpeg,bmp,png|max:4096',

            'type' => 'required|in:admin,user',
            'password' => 'nullable|string|min:6|max:255',
        ]);

        $educationPicture = null;
        if ($request->hasFile('educationPicture')) {
            $educationPicture = $request->file('educationPicture')->store('uplaods/users');
        }

        $personalPicture = null;
        if ($request->hasFile('personalPicture')) {
            $personalPicture = $request->file('personalPicture')->store('uplaods/users');
        }

        $nationalCardPicture = null;
        if ($request->hasFile('nationalCardPicture')) {
            $nationalCardPicture = $request->file('nationalCardPicture')->store('uplaods/users');
        }


        $user = User::create([
            'city_id' => $request->input('city_id', null),

            'userName' => $request->input('userName', null),
            'email' => $request->input('email', null),
            'firstName' => $request->input('firstName', null),
            'lastName' => $request->input('lastName', null),
            'fatherName' => $request->input('fatherName', null),
            'gender' => $request->input('gender'),
            'nationalCode' => $request->input('nationalCode', null),
            'certificateCode' => $request->input('certificateCode', null),
            'postalCode' => $request->input('postalCode', null),
            'birthday' => $request->input('birthday', null),
            'birthplace' => $request->input('birthplace', null),
            'mobile' => $request->input('mobile', null),
            'telephone' => $request->input('telephone', null),
            'address' => $request->input('address', null),
            'education' => $request->input('education', null),
            'fieldOfStudy' => $request->input('fieldOfStudy', null),
            'saveSkill' => $request->has('saveSkill'),
            'canEdit' => $request->has('canEdit'),
            'isAdmin' => ($request->input('type') == 'admin') ? 1 : 0,
            'type' => $request->input('type'),
            'password' => bcrypt($request->input('password', null)),
            'isActive' => $request->has('isActive'),
            'api_token' => Str::random(64),

            'educationPicture' => $educationPicture,
            'personalPicture' => $personalPicture,
            'nationalCardPicture' => $nationalCardPicture,
        ]);

        $user->role()->sync(json_decode($request->input('roles_id')));
        $user->skill()->sync($request->input('skill_id'));


        message();
        return redirect()->route('admin.users.index');
    }

    public function edit(User $user)
    {
        $this->authorize('user_crud_update');

        $skill = [];
        if (isset($user->skill[0])) {
            $skill = $user->skill[0];
        }

        return view('admin.users.edit',compact('user','skill'));
    }

    public function update(Request $request,User $user)
    {
        $this->authorize('user_crud_update');

        $request->offsetSet('birthday',toGorgian($request->input('birthday',null)));

        $this->validate($request, [
            'skill_id' => 'nullable|numeric|exists:skills,id',
            'city_id' => 'required|numeric|exists:cities,id',
            'roles_id.*' => [
                'required',
                Rule::exists('roles', 'id')->whereIn('id', auth()->user()->allRoles()->pluck('id')->toArray())
            ],

            'userName' => [
                'required',
                'string',
                'max:255',
                Rule::unique('users')->ignore($user->userName, 'userName'),
            ],

            'email' => 'nullable|string|min:3|max:255',
            'firstName' => 'required|string|max:255',
            'lastName' => 'required|string|max:255',
            'fatherName' => 'nullable|string|max:255',
            'gender' => 'required|in:male,female',
            'nationalCode' => ['nullable', 'numeric', new nationalCode()],
            'certificateCode' => 'nullable|string|min:1|max:11',
            'postalCode' => 'nullable|digits_between:9,11',
            'birthday' => 'required|before:2005-01-01',
            'birthplace' => 'required|string|min:4|max:255',
            'mobile' => 'nullable|numeric',
            'telephone' => 'nullable|numeric',
            'address' => 'nullable|string|min:4|max:2048',
            'education' => 'required|in:1,2,3,4,5,6',
            'fieldOfStudy' => 'required|string|min:4|max:255',

            'educationPicture' => 'nullable|image|mimes:jpeg,bmp,png|max:4096',
            'personalPicture' => 'nullable|image|mimes:jpeg,bmp,png|max:4096',
            'nationalCardPicture' => 'nullable|image|mimes:jpeg,bmp,png|max:4096',

            'type' => 'required|in:admin,user',
            'password' => 'nullable|string|min:6|max:255',
        ]);

        if ($request->hasFile('educationPicture')) {
            Storage::delete($user->educationPicture);
            $user->educationPicture = $request->file('educationPicture')->store('uploads/users');
        }

        if ($request->hasFile('personalPicture')) {
            Storage::delete($user->personalPicture);
            $user->personalPicture = $request->file('personalPicture')->store('uploads/users');
        }

        if ($request->hasFile('nationalCardPicture')) {
            Storage::delete($user->nationalCardPicture);
            $user->nationalCardPicture = $request->file('nationalCardPicture')->store('uploads/users');
        }


        $user->update([
            'city_id' => $request->input('city_id', null),

            'userName' => $request->input('userName', null),
            'email' => $request->input('email', null),
            'firstName' => $request->input('firstName', null),
            'lastName' => $request->input('lastName', null),
            'fatherName' => $request->input('fatherName', null),
            'gender' => $request->input('gender'),
            'nationalCode' => $request->input('nationalCode', null),
            'certificateCode' => $request->input('certificateCode', null),
            'postalCode' => $request->input('postalCode', null),
            'birthday' => $request->input('birthday', null),
            'birthplace' => $request->input('birthplace', null),
            'mobile' => $request->input('mobile', null),
            'telephone' => $request->input('telephone', null),
            'address' => $request->input('address', null),
            'education' => $request->input('education', null),
            'fieldOfStudy' => $request->input('fieldOfStudy', null),
            'saveSkill' => $request->has('saveSkill'),
            'canEdit' => $request->has('canEdit'),
            'isAdmin' => ($request->input('type') == 'admin') ? 1 : 0,
            'type' => $request->input('type'),
            'password' => bcrypt($request->input('password', null)),
            'isActive' => $request->has('isActive'),

            'educationPicture' => $user->educationPicture,
            'personalPicture' => $user->personalPicture,
            'nationalCardPicture' => $user->nationalCardPicture,
        ]);

        $user->role()->sync(json_decode($request->input('roles_id')));
        $user->skill()->sync($request->input('skill_id'));


        if ($request->has('password')) {
            $user->update(['password'=>bcrypt($request->input('password'))]);
        }

        message();
        return redirect()->route('admin.users.edit',$user->id);
    }

    public function destroy(User $user)
    {
        $this->authorize('user_crud_destroy');

        return response()->json($user->delete());
    }


    // Extra Methods

    public function login(User $user)
    {
        $this->authorize('user_crud_login');

        if ($user->isAdmin) {
            auth()->loginUsingId($user->id);
            return redirect()->to('/panel/admin/home');
        } else {
            auth()->loginUsingId($user->id);
            return redirect()->to('/panel/user/home');
        }
    }

    public function excel()
    {
        return Excel::download(new UsersExport(), 'users.xlsx');
    }

    public function changeStatus(user $user)
    {
        $this->authorize('user_crud_changestatus');
        $serviceCardStatus = $user->serviceCardStatus;

        return view('admin.users.changeStatus',compact('user','serviceCardStatus'));
    }

    public function changeStatusStore(user $user,Request $request)
    {
        $this->authorize('user_crud_changestatus');

        $request->offsetSet('cardstatus_id',json_decode($request->input('cardstatus_id')));

        $this->validate($request, [
            'cardstatus_id.*' => 'nullable|numeric|exists:service_card_statuses,id'
        ]);

        $user->update([
            'isActive' => $request->has('isActive'),
            'canEdit' => $request->has('canEdit'),
        ]);
        $user->serviceCardStatus()->sync($request->input('cardstatus_id'));
        message();

        return redirect()->route('admin.users.changeStatusStore',$user->id);
    }
}
