<?php

namespace App\Http\Controllers\Admin\Region;

use App\Http\Controllers\Controller;
use App\Models\Region\area;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class AreaController extends Controller
{
    public function index()
    {
        $this->authorize('area_index');

        if (request()->has('page')){
            $list = area::with('city')->search()->latest()->paginate();

            return response()->json($list);
        }

        return view('admin.Region.area.index');
    }

    public function create()
    {
        $this->authorize('area_store');

        return view('admin.Region.area.create');
    }

    public function store(Request $request)
    {
        $this->authorize('area_store');

        $this->validate($request, [
            'title' => 'required|string|max:255|unique:areas,title',
            'order' => 'required|numeric',
            'city_id' => 'required|exists:cities,id',
        ]);

        area::create([
            'city_id' => $request->input('city_id'),
            'title' => $request->input('title'),
            'latitude' => $request->input('latitude'),
            'order' => $request->input('order'),
            'status' => $request->has('status')
        ]);

        message();
        return redirect()->route('admin.region.area.index');
    }

    public function show(area $area)
    {
        $this->authorize('area_show');

        return response()->json($area);
    }

    public function edit(area $area)
    {
        $this->authorize('area_update');

        return view('admin.Region.area.edit', compact('area'));
    }

    public function update(Request $request, area $area)
    {
        $this->authorize('area_update');

        $this->validate($request, [
            'title' => [
                'required',
                'string',
                'max:255',
                Rule::unique('areas')->ignore($area->id),
            ],
            'order' => 'required|numeric',
            'city_id' => 'required|exists:cities,id',
        ]);

        $area->update([
            'city_id' => $request->input('city_id'),
            'title' => $request->input('title'),
            'latitude' => $request->input('latitude'),
            'order' => $request->input('order'),
            'status' => $request->has('status')
        ]);

        message('ویرایش شد.');
        return redirect()->route('admin.region.area.edit', $area->id);
    }

    public function destroy(area $area)
    {
        $this->authorize('area_destroy');

        return response()->json($area->delete());
    }

}
