<?php

namespace App\Http\Controllers\Admin\Region;

use App\Http\Controllers\Controller;
use App\Models\Region\city;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class CityController extends Controller
{
    public function index()
    {
        $this->authorize('city_index');

        if (request()->has('page')){
            $list = city::with('state')->search()->latest()->paginate();

            return response()->json($list);
        }

        return view('admin.Region.city.index');
    }

    public function create()
    {
        $this->authorize('city_store');

        return view('admin.Region.city.create');
    }

    public function store(Request $request)
    {
        $this->authorize('city_store');

        $this->validate($request, [
            'state_id' => 'required|exists:states,id',
            'title' => 'required|string|max:255|unique:cities,title',
            'order' => 'required|numeric',
        ]);

        city::create([
            'state_id' => $request->input('state_id'),
            'title' => $request->input('title'),
            'latitude' => $request->input('latitude'),
            'order' => $request->input('order'),
            'status' => $request->has('status'),
        ]);

        message();
        return redirect()->route('admin.region.city.index');
    }

    public function show(city $city)
    {
        $this->authorize('city_show');

        return response()->json($city);
    }

    public function edit(city $city)
    {
        $this->authorize('city_update');

        return view('admin.Region.city.edit',compact('city'));
    }

    public function update(Request $request, city $city)
    {
        $this->authorize('city_update');

        $this->validate($request, [
            'title' => [
                'required',
                'string',
                'max:255',
                Rule::unique('cities')->ignore($city->id),
            ],
            'order' => 'required|numeric',
            'state_id' => 'required|exists:states,id',
        ]);

        $city->update([
            'state_id' => $request->input('state_id'),
            'title'    => $request->input('title'),
            'latitude' => $request->input('latitude'),
            'order'    => $request->input('order'),
            'status'   => $request->has('status'),
        ]);

        message('ویرایش شد.');
        return redirect()->route('admin.region.city.edit',$city->id);
    }

    public function destroy(city $city)
    {
        $this->authorize('city_update');

        return response()->json($city->delete());
    }

}
