<?php

namespace App\Http\Controllers\Admin\Service;

use App\Http\Controllers\Controller;
use App\Models\Service\serviceOffer;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class offerController extends Controller
{
    public function index()
    {
        $this->authorize('serviceOffer_index');

        if (request()->has('page')) {
            $list = serviceOffer::search()->latest()->paginate();

            return response()->json($list);
        }

        return view('admin.Service.offer.index');
    }

    public function create()
    {
        $this->authorize('serviceOffer_store');


        return view('admin.Service.offer.create');
    }

    public function store(Request $request)
    {
        $this->authorize('serviceOffer_store');

        $this->validate($request, [
            'title' => 'required|string|min:2|max:255',
            'code' => 'nullable|string|min:2|max:255',
            'link' => 'required|url|string|min:4|max:4096',
            'type' => 'required|in:offer,service',
            'body' => 'nullable|string|min:4|max:40096',
            'picture' => 'nullable|image|mimes:jpeg,bmp,png|max:4096',
        ]);

        $picture = null;
        if ($request->hasFile('picture')) {
            $picture = $request->file('picture')->store('uploads/service_offers');
        }

        $serviceOffer = serviceOffer::create([
            'title' => $request->input('title'),
            'code' => $request->input('code'),
            'link' => $request->input('link'),
            'body' => $request->input('body'),
            'type' => $request->input('type'),
            'expire' => toGorgian($request->input('expire'),'Y/m/d H:i:s'),
            'picture' => $picture,
            'status' => $request->has('status')
        ]);
        $serviceOffer->category()->attach(json_decode($request->input('category_id')));

        message();
        return redirect()->route('admin.service.offer.index');
    }

    public function show($id)
    {
        $this->authorize('serviceOffer_show');

        return response()->json($id);
    }

    public function edit($id)
    {
        $this->authorize('serviceOffer_update');

        $serviceOffer = serviceOffer::findOrFail($id);

        return view('admin.Service.offer.edit', compact('serviceOffer'));
    }

    public function update(Request $request, $id)
    {
        $this->authorize('serviceOffer_update');

        $serviceOffer = serviceOffer::findOrFail($id);


        $picture = $serviceOffer->picture;
        if ($request->hasFile('picture')) {
            Storage::delete($picture);
            $picture = $request->file('picture')->store('uploads/service_offers');
        }

        $this->validate($request, [
            'title' => 'required|string|min:2|max:255',
            'code' => 'nullable|string|min:2|max:255',
            'link' => 'required|url|string|min:4|max:4096',
            'type' => 'required|in:offer,service',
            'body' => 'nullable|string|min:4|max:40096',
            'picture' => 'nullable|image|mimes:jpeg,bmp,png|max:4096',
        ]);

        $serviceOffer->update([
            'title' => $request->input('title'),
            'code' => $request->input('code'),
            'link' => $request->input('link'),
            'body' => $request->input('body'),
            'type' => $request->input('type'),
            'expire' => toGorgian($request->input('expire'),'Y/m/d H:i:s'),
            'picture' => $picture,
            'status' => $request->has('status')
        ]);
        $serviceOffer->category()->sync(json_decode($request->input('category_id')));

        message('ویرایش شد.');
        return redirect()->route('admin.service.offer.edit', $serviceOffer->id);
    }

    public function destroy($id)
    {
        $this->authorize('serviceOffer_destroy');

        $serviceOffer = serviceOffer::findOrFail($id);

        return response()->json($serviceOffer->delete());
    }

}
