<?php

namespace App\Http\Controllers\Admin\setting;

use App\Http\Controllers\Controller;
use App\Models\Setting\settingCategoryAdmin;
use Illuminate\Http\Request;

class SettingCategoryAdminController extends Controller
{
    public function index()
    {
        $this->authorize('settingCat_index');

        if (request()->has('page')){
            $list = settingCategoryAdmin::search()->withCount('settingsAdmin')->latest()->paginate();

            return response()->json($list);
        }

        return view('admin.Setting.category.index');
    }

    public function create()
    {
        $this->authorize('settingCat_store');

        return view('admin.Setting.category.create');
    }

    public function store(Request $request)
    {
        $this->authorize('settingCat_store');

        $this->validate($request, [
            'title' => 'required|string|max:255',
            'order' => 'required|numeric',
        ]);

        settingCategoryAdmin::create([
            'title'  => $request->input('title'),
            'order'  => $request->input('order'),
            'status' => $request->has('status'),
        ]);

        message();
        return redirect()->route('admin.settingcategory.index');
    }

    public function show(settingCategoryAdmin $settingcategory)
    {
        $this->authorize('settingCat_show');

        return response()->json($settingcategory);
    }

    public function edit(settingCategoryAdmin $settingcategory)
    {
        $this->authorize('settingCat_update');

        return view('admin.Setting.category.edit',compact('settingcategory'));
    }

    public function update(Request $request, settingCategoryAdmin $settingcategory)
    {
        $this->authorize('settingCat_update');

        $this->validate($request, [
            'title' => 'required|string|max:255',
            'order' => 'required|numeric',
        ]);

        $settingcategory->update([
            'title'  => $request->input('title'),
            'order'  => $request->input('order'),
            'status' => $request->has('status'),
        ]);

        message('Edited');
        return redirect()->route('admin.settingcategory.edit',$settingcategory->id);
    }

    public function destroy(settingCategoryAdmin $settingcategory)
    {
        $this->authorize('settingCat_destroy');

        return response()->json($settingcategory->delete());
    }
}
