<?php

namespace App\Http\Controllers\Admin\Skill;

use App\Http\Controllers\Controller;
use App\Models\Region\area;
use App\Models\Skill\skill;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class skillController extends Controller
{
    public function index()
    {
        $this->authorize('skill_index');

        if (request()->has('page')){
            $list = skill::search()->latest()->paginate();

            return response()->json($list);
        }

        return view('admin.Skil.skill.index');
    }

    public function create()
    {
        $this->authorize('skill_store');

        return view('admin.Skil.skill.create');
    }

    public function store(Request $request)
    {
        $this->authorize('skill_store');

        $this->validate($request, [
            'title' => 'required|string|max:255|unique:skills,title',
        ]);

        $skill = skill::create([
            'title' => $request->input('title'),
            'status' => $request->has('status')
        ]);
        $skill->category()->attach(json_decode($request->input('category_id')));

        message();
        return redirect()->route('admin.skill.skill.index');
    }

    public function show(skill $skill)
    {
        $this->authorize('skill_show');

        return response()->json($skill);
    }

    public function edit($id)
    {
        $this->authorize('skill_update');
        $skill = skill::findOrFail($id);

        return view('admin.Skil.skill.edit', compact('skill'));
    }

    public function update(Request $request, $id)
    {
        $this->authorize('skill_update');
        $skill = skill::findOrFail($id);

        $this->validate($request, [
            'title' => [
                'required',
                'string',
                'max:255',
                Rule::unique('skills')->ignore($skill->id),
            ],
        ]);

        $skill->update([
            'title' => $request->input('title'),
            'status' => $request->has('status')
        ]);
        $skill->category()->sync(json_decode($request->input('category_id')));

        message('ویرایش شد.');
        return redirect()->route('admin.skill.skill.edit', $skill->id);
    }

    public function destroy($id)
    {
        $this->authorize('skill_destroy');
        $serviceCard = skill::findOrFail($id);

        return response()->json($serviceCard->delete());
    }

}
