<?php

namespace App\Http\Controllers\Admin\Ticket;

use App\Http\Controllers\Admin\exportExcel\TicketExport;
use Maatwebsite\Excel\Facades\Excel;
use App\Http\Controllers\Controller;
use App\Models\Ticket\ticket;
use App\Models\Ticket\ticketDepartment;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class TicketController extends Controller
{

    public function index()
    {
        $this->authorize('ticketManage_index');

        if (request()->has('page')) {
            $list = ticket::with('user','department')->withCount('referer')->search()->latest()->paginate();

            return response()->json($list);
        }

        return view('admin.Ticket.manageTicket.index');
    }

    public function create()
    {
        $this->authorize('ticketManage_store');

        return view('admin.Ticket.manageTicket.create');
    }

    public function store(Request $request)
    {
        $this->authorize('ticketManage_store');

        $request->offsetSet('admins_id', json_decode($request->input('admins_id')));
        $request->offsetSet('user_id', json_decode($request->input('user_id')));


        if (!$request->hasFile('excel') &&count($request->input('user_id')) == 0) {
            message('خطا','لطفا کاربر انتخاب کنید','error');
            return redirect()->route('admin.tickets.create');
        }


        $this->validate($request, [
            'department_id' => 'required|exists:ticket_departments,id',
            'admins_id.*' => 'required|exists:users,id',
            'user_id.*' => 'required|exists:users,id',
            'title' => 'required|string|max:512',
            'priority' => 'required|in:urgent,high,medium,low',
            'body' => 'required|string',
            'status' => 'required|in:open,pending,close,deactive',
            'file' => 'nullable|mimes:jpeg,bmp,png,zip,rar,doc,docs,xls|max:10240',
            'excel' => 'nullable|mimes:xls|max:10240',
        ]);



        if ($request->hasFile('excel')) {
            \Maatwebsite\Excel\Facades\Excel::import(new UserImport(), request()->file('excel'));
        } else {
            $file = null;
            if ($request->hasFile('file')) {
                $file = $request->file('file')->store('uploads/tickets');
            }
            foreach ($request->input('user_id') as $user_id) {
                $ticket = ticket::create([
                    'ticketDepartment_id' => $request->input('department_id'),
                    'user_id' => $user_id,
                    'title' => $request->input('title'),
                    'priority' => $request->input('prority'),
                    'body' => $request->input('body'),
                    'pathFile' => $file,
                    'status' => $request->input('status'),
                ]);
                $ticket->referer()->attach($request->input('admins_id'));
            }
        }


        message();
        return redirect()->route('admin.tickets.index');
    }

    public function show($id)
    {
        $this->authorize('ticketManage_show');

        return response()->json(ticket::findOrFail($id));
    }

    public function edit($id)
    {
        $this->authorize('ticketManage_update');

        $ticket = ticket::findOrFail($id);
        $departments = ticketDepartment::validate()->get();

        return view('admin.Ticket.manageTicket.edit',compact('ticket','departments'));
    }

    public function update(Request $request, $id)
    {
        $this->authorize('ticketManage_update');

        $ticket = ticket::findOrFail($id);

        $request->offsetSet('admins_id', json_decode($request->input('admins_id')));

        $this->validate($request, [
            'department_id' => 'required|exists:ticket_departments,id',
            'admins_id.*'   => 'required|exists:users,id',
            'user_id'       => 'required|exists:users,id',
            'title'         => 'required|string|max:512',
            'priority'      => 'required|in:urgent,high,medium,low',
            'body'          => 'required|string',
            'status'        => 'required|in:open,pending,close,deactive',
            'file'          => 'nullable|mimes:jpeg,bmp,png,zip,rar,doc,docs,xls|max:10240',
        ]);

        if ($request->hasFile('file')) {
            Storage::delete($ticket->pathFile);
            $ticket->pathFile = $request->file('file')->store('uploads/tickets');
        }

        $ticket->update([
            'ticketDepartment_id' => $request->input('department_id'),
            'user_id'             => $request->input('user_id'),
            'title'               => $request->input('title'),
            'priority'            => $request->input('prority'),
            'body'                => $request->input('body'),
            'pathFile'            => $ticket->pathFile,
            'status'              => $request->input('status'),
        ]);

        $ticket->referer()->sync($request->input('admins_id'));

        message();
        return redirect()->route('admin.tickets.edit',$ticket->id);
    }

    public function destroy($id)
    {
        $this->authorize('ticketManage_destroy');

        $ticket = ticket::findOrFail($id);
        Storage::delete($ticket->pathFile);

        return response()->json($ticket->delete());
    }


    // Extra Methods

    public function excel()
    {
        return Excel::download(new TicketExport(), 'ticket.xlsx');
    }
}
