<?php

namespace App\Http\Controllers\Admin\Ticket;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class TicketSendGroupFilterController extends Controller
{
    public function create()
    {
        $this->authorize('ticketManage_store');

        return view('admin.Ticket.groupFilter.create');
    }

    public function store(Request $request)
    {
        $this->authorize('ticketManage_store');

        $validators = Validator::make($request->all(), [
            'body' => 'required|string|min:2|max:1000024'
        ]);

        if ($validators->fails()) {
            return response()->json([
                'data' => [
                    'users' => []
                ],
                'meta' => [
                    'code' => 422,
                    'status' => 'validation error',
                    'msg' => $validators->errors()->all(),
                ]
            ]);
        }




        message();
        return redirect()->route('admin.tickets.index');
    }
}
