<?php

namespace App\Http\Controllers\Admin\Wallet;

use App\Http\Controllers\Controller;
use App\Models\Wallet\Wallet;
use App\Models\Wallet\walletTransaction;
use App\User;
use Illuminate\Http\Request;

class walletTransactionController extends Controller
{
    public function index()
    {
        $this->authorize('walletTransaction_index');

        if (request()->has('page')) {
            $list = walletTransaction::search()->with('wallet.model')->latest()->paginate();

            return response()->json($list);
        }

        return view('admin.Wallet.transaction.index');
    }

    public function create()
    {
        $this->authorize('walletTransaction_store');

        return view('admin.Wallet.transaction.create');
    }

    public function store(Request $request)
    {
        $this->authorize('walletTransaction_store');

        $request->offsetSet('amount', str_replace(',', '', $request->input('amount')));

        $this->validate($request, [
            'wallet_id' => 'required|numeric|exists:wallets,id',
            'amount' => 'required|numeric'
        ]);


        $wallet = Wallet::findOrFail($request->input('wallet_id'));
        if ($request->input('amount') > 0) {
            $wallet->update([
                'deposit' => $wallet->deposit + $request->input('amount'),
                'amount' => $wallet->amount + $request->input('amount'),
            ]);
        } else {
            $wallet->update([
                'withdraw' => $wallet->withdraw + abs($request->input('amount')),
                'amount' => $wallet->amount - abs($request->input('amount')),
            ]);
        }

        $wallet->transaction()->create([
            'type' => 'manual',
            'amount' => $request->input('amount'),
            'body' => null,
            'editedBy' => auth()->user()->id . '-' . auth()->user()->firstName . '-' . auth()->user()->lastName,
            'status' => 1
        ]);

        message();
        return redirect()->route('admin.wallet.transaction.index');
    }
}
