<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use App\Models\Service\serviceCategory;
use App\Models\User\userMobileVerify;

class serviceCategoryController extends Controller
{
    public function index()
    {
        $categories = serviceCategory::whereHas('department', function ($query) {
            $query->where('service_departments.id', 7);
        })->validate()->latest()->paginate(50);

        return view('front.service.serviceCategory.index', compact('categories'));
    }

    public function show($id)
    {
        $offerCategory = serviceCategory::validate()->findOrFail($id);

        return view('front.service.serviceCategory.show', compact('offerCategory'));
    }
}
