<?php

namespace App\Http\Controllers\User\Profile;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class changePasswordController extends Controller
{
    public function edit()
    {
        return view('user.profile.password');
    }

    public function update(Request $request)
    {
        $this->validate($request, [
            'old_password' => 'required|string|max:256',
            'password' => 'required|string|min:8|max:256|confirmed',
        ]);

        if (!Auth::attempt(['userName' => auth()->user()->userName, 'password' => $request->input('old_password')])) {
            message('خطا','رمز عبور فعلی درست نمیباشد','error');
            return redirect()->route('user.profile.changepassword.edit');
        }

        auth()->user()->update([
            'password' => bcrypt($request->input('password'))
        ]);
        auth()->logout();
        return redirect()->route('auth.login');


        message();
        return redirect()->route('user.profile.changepassword.edit');
    }


    // Reset password

    public function ResetPasswordEdit()
    {
        return view('user.profile.password');
    }

    public function ResetPasswordUpdate(Request $request)
    {
        $this->validate($request, [
            'password' => 'required|string|min:6|max:256|confirmed',
        ]);

        auth()->user()->update([
            'password' => bcrypt($request->input('password'))
        ]);


        auth()->logout();
        return redirect()->route('auth.login');
    }
}
