<?php

namespace App\Http\Controllers\User\Profile;

use App\Http\Controllers\Controller;
use App\Libraries\Rules\FarsiValidation;
use App\Libraries\Rules\nationalCode;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Validation\Rule;

class userProfileController extends Controller
{
    public function edit()
    {
        $disabled = (auth()->user()->canEdit) ? '' : 'disabled';

        $skill = [];
        if (isset(auth()->user()->skill[0])) {
            $skill = auth()->user()->skill[0];
        }

        return view('user.profile.edit',compact('disabled','skill'));
    }

    public function update(Request $request )
    {
        $request->offsetSet('birthday',toGorgian($request->input('birthday',null)));
        $request->offsetSet('mobile', convertNumbers($request->input('mobile')));
        $request->offsetSet('postalCode', convertNumbers($request->input('postalCode')));
        $request->offsetSet('telephone', convertNumbers($request->input('telephone')));


        if (auth()->user()->canEdit) {
            $this->validate($request, [
                'skill_id' => 'nullable|numeric|exists:skills,id',
                'city_id' => 'required|numeric|exists:cities,id',

                'email' => [
                    'required',
                    'email',
                    'string',
                    'max:255',
                    Rule::unique('users')->ignore(auth()->user()->email, 'email'),
                ],

                'firstName' => [
                    'required',
                    'string',
                    'min:2',
                    'max:255',
                    new FarsiValidation(),
                ],
                'lastName' => [
                    'required',
                    'string',
                    'min:2',
                    'max:255',
                    new FarsiValidation(),
                ],
                'fatherName' => 'nullable|string|max:255',
                'gender' => 'required|in:male,female',
                'nationalCode' => [
                    'required',
                    'numeric',
                    new nationalCode(),
                ],
                'certificateCode' => 'nullable|string|min:1|max:16',
                'postalCode' => 'nullable|digits_between:9,11',
                'birthday' => 'required|before:2005-01-01',
                'birthplace' => 'required|string|min:2|max:255',
                'mobile' => 'required|numeric|digits_between:9,11',
                'telephone' => 'required|numeric|digits_between:9,11',
                'address' => 'required|string|min:4|max:2048',
                'education' => 'required|in:1,2,3,4,5,6',
                'fieldOfStudy' => 'required|string|min:4|max:255',
                'educationPicture' => 'required|image|mimes:jpeg,bmp,png|max:4096',
                'personalPicture' => 'required|image|mimes:jpeg,bmp,png|max:4096',
                'nationalCardPicture' => 'required|image|mimes:jpeg,bmp,png|max:4096'
            ]);

            if ($request->hasFile('educationPicture')) {
                Storage::delete(auth()->user()->educationPicture);
                auth()->user()->educationPicture = $request->file('educationPicture')->store('uploads/users');
            }

            if ($request->hasFile('personalPicture')) {
                Storage::delete(auth()->user()->personalPicture);
                auth()->user()->personalPicture = $request->file('personalPicture')->store('uploads/users');
            }

            if ($request->hasFile('nationalCardPicture')) {
                Storage::delete(auth()->user()->nationalCardPicture);
                auth()->user()->nationalCardPicture = $request->file('nationalCardPicture')->store('uploads/users');
            }



            auth()->user()->update([
                'city_id' => $request->input('city_id', null),

                'userName' => $request->input('mobile', null),
                'email' => $request->input('email', null),
                'firstName' => $request->input('firstName', null),
                'lastName' => $request->input('lastName', null),
                'fatherName' => $request->input('fatherName', null),
                'gender' => $request->input('gender'),
                'nationalCode' => $request->input('nationalCode', null),
                'certificateCode' => $request->input('certificateCode', null),
                'postalCode' => $request->input('postalCode', null),
                'birthday' => $request->input('birthday', null),
                'birthplace' => $request->input('birthplace', null),
                'mobile' => $request->input('mobile', null),
                'telephone' => $request->input('telephone', null),
                'address' => $request->input('address', null),
                'education' => $request->input('education', null),
                'fieldOfStudy' => $request->input('fieldOfStudy', null),
                'saveSkill' => $request->has('saveSkill'),
                'canEdit' => 0,
                'isActive' => 1,

                'educationPicture' => auth()->user()->educationPicture,
                'personalPicture' => auth()->user()->personalPicture,
                'nationalCardPicture' => auth()->user()->nationalCardPicture,
            ]);
            auth()->user()->skill()->sync($request->input('skill_id'));

            message();
        } else {
            message('خطا', 'حساب کاربری شما فعال شده است و شما قادر به ویرایش پروفایل نیستید', 'error');
        }


        return redirect()->route('user.profile.edit');
    }
}
