<?php

namespace App\Http\Controllers\User\Ticket;

use App\Http\Controllers\Controller;
use App\Models\Ticket\ticket;
use App\Models\Ticket\ticketDepartment;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class TicketController extends Controller
{

    public function index()
    {
        if (request()->has('page')) {
            $list = auth()->user()->tickets()->with('user','department')->withCount('messages')->search()->latest()->paginate();
            return response()->json($list);
        }

        return view('user.Ticket.ticket.index');
    }

    public function create()
    {
        $departments = ticketDepartment::validate()->get()->pluck('title', 'id');

        return view('user.Ticket.message.create',compact('departments'));
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'department_id' => 'required|exists:ticket_departments,id',
            'title'         => 'required|string|max:512',
            'priority'      => 'required|in:urgent,high,medium,low',
            'body'          => 'required|string',
            'file'          => 'nullable|mimes:jpeg,bmp,png,zip,rar,doc,docs,xls|max:1000',
        ]);

        $file = null;
        if ($request->hasFile('file')) {
            $file = $request->file('file')->store('uploads/tickets');
        }

        ticket::create([
            'ticketDepartment_id' => $request->input('department_id'),
            'user_id'             => auth()->user()->id,
            'title'               => $request->input('title'),
            'priority'            => $request->input('prority'),
            'body'                => $request->input('body'),
            'pathFile'            => $file,
        ]);

        message();
        return redirect()->route('user.tickets.index');
    }

}
