<?php

namespace App\Http\Controllers\User\Ticket;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class TicketMessageController extends Controller
{

    public function indexMessage($id)
    {
        $ticket = auth()->user()->tickets()->validate()->findOrFail($id);
        $messages = $ticket->messages()->with('user')->where('type', 'all')->get();
        $ticket->update(['isRead' => 1]);

        return view('user.Ticket.message.indexMessages',compact('ticket','messages'));
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'ticket_id' => 'required|exists:tickets,id',
            'body' => 'required|string',
            'files.*' => 'nullable|mimes:jpeg,bmp,png,zip,rar,doc,docs,xls|max:20000'
        ]);

        $ticket = auth()->user()->tickets()->validate()->findOrFail($request->input('ticket_id'));
        $message = $ticket->messages()->create([
            'user_id' => auth()->user()->id,
            'body'    => $request->input('body'),
            'type'    => 'all'
        ]);

        if ($request->hasFile('files')) {
            foreach ($request->file('files') as $file) {
                $message->files()->create([
                    'path' => $file->store('uploads/ticket_files'),
                    'mime' => $file->getClientMimeType(),
                    'size' => $file->getClientSize()/1000,
                ]);
            }
        }

        message();
        return redirect()->route('user.ticketmessages.indexMessage',$request->input('ticket_id'));
    }
}
