<?php

namespace App\Http\Controllers\User\Wallet;

use App\Http\Controllers\Controller;
use App\Models\Wallet\walletRequest;
use Illuminate\Http\Request;

class walletRequestController extends Controller
{
    public function index()
    {
        $wallet = auth()->user()->getWallet();
        if (request()->has('page')) {
            $list = walletRequest::own()->search()->with('wallet.model')->latest()->paginate();

            return response()->json($list);
        }

        return view('user.Wallet.request.index', compact('wallet'));
    }

    public function create()
    {
        return view('user.Wallet.request.create');
    }

    public function store(Request $request)
    {
        $request->offsetSet('amount', str_replace(',', '', $request->input('amount')));

        $this->validate($request, [
            'amount' => 'required|numeric|digits_between:1,18'
        ]);


        $wallet = auth()->user()->getWallet();
        if ($wallet->amount < $request->input('amount')) {
            message('خطا', 'مقدار مبلغ درخواستی بیش از مبلغ کیف پول شما میباشد', 'error');
            return redirect()->route('user.wallet.request.index');
        }

        $wallet->request()->create([
            'amount' => $request->input('amount'),
            'status' => 'pending'
        ]);


        return redirect()->route('user.wallet.request.index');
    }

    public function show($id)
    {
        $request = walletRequest::own()->findOrFail($id);

        return view('admin.Wallet.request.show', compact('request'));
    }
}
