<?php

namespace App\Http\Controllers\customAuth;

use App\Http\Controllers\Controller;
use App\Models\User\userMobileVerify;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Melipayamak\MelipayamakApi;

class confirmMobileController extends Controller
{

    public function create()
    {
        return redirect()->to('/panel/user/home');

        if (auth()->user()->mobile_verified_at) {
            return redirect()->to('/panel/user/home');
        }
        return view('customAuth.confirmMobile.create');
    }

    public function store(Request $request)
    {
        if (auth()->user()->mobile_verified_at) {
            return redirect()->to('/panel/user/home');
        }

        if (isset(session('confirmMobile')['expire']) && session('confirmMobile')['expire'] > now()) {
            $request->offsetSet('code', convertNumbers($request->input('code')));

            $this->validate($request, [
                'code' => 'required|string|min:5|max:8'
            ]);

            if ($request->input('code') == session('confirmMobile')['code']) {
                auth()->user()->update([
                    'mobile_verified_at' => now(),
                ]);

                session()->forget('confirmMobile');
                message();
                return redirect()->to('/panel/user/home');
            } else {
                message('خطا', 'کد صحیح نمیباشد', 'error');
                return redirect()->route('auth.confirm.create');
            }

        } else {
            message('خطا', 'اعتبار کد ارسالی تمام شده است', 'error');
            return redirect()->route('auth.confirm.create');
        }

    }


    public function sms()
    {
        return redirect()->to('/panel/user/home');

        if (auth()->user()->mobile_verified_at) {
            return redirect()->to('/panel/user/home');
        }

        if (isset(session('confirmMobile')['count']) && session('confirmMobile')['count'] > 4) {


            if (isset(session('confirmMobile')['isBlock']) && session('confirmMobile')['isBlock'] == 0) {

                session(['confirmMobile' =>
                    [
                        'code' => session('confirmMobile')['code'],
                        'expire' => session('confirmMobile')['expire'],
                        'count' => session('confirmMobile')['count'] + 1,
                        'isBlock' => 1,
                        'blockExpire' => now()->addMinute(10)
                    ]
                ]);
                message('خطا', 'شما بیش از ۵ بار برای تاییدیه sms درخواست کرده اید لطفا ۱۰ دقیقه بعد اقدام فرمایید', 'error');
                return redirect()->route('auth.confirm.create');
            } elseif (session('confirmMobile')['blockExpire'] < now()) {
                session()->forget('confirmMobile');
            } else {

                message('خطا', 'شما بیش از ۵ بار برای تاییدیه sms درخواست کرده اید لطفا ۱۰ دقیقه بعد اقدام فرمایید', 'error');
                return redirect()->route('auth.confirm.create');
            }

        }

        $code = random_int(00, 99) . strtolower(Str::random(3)) . random_int(00, 99);
        $api = new MelipayamakApi(env('meliPayamakUser'), env('meliPayamakPassword'));
        $api->sms()->send(auth()->user()->mobile, '500010009108498', "کد تاییدیه شما $code میباشد.");
        session(['confirmMobile' =>
            [
                'code' => $code,
                'expire' => now()->addMinute(2),
                'count' => session('confirmMobile')['count'] + 1,
                'isBlock' => 0,
                'blockExpire' => null
            ]
        ]);

        message('موفق','کد با موفقیت ارسال شد','success',true);
        return redirect()->route('auth.confirm.create');
    }

}
