<?php

namespace App\Http\Controllers\customAuth;

use App\Http\Controllers\Controller;
use App\Libraries\Rules\nationalCode;
use App\Models\Skill\skill;
use App\Models\User\userMobileVerify;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;

class customAuthController extends Controller
{
    public function login()
    {
        return view('customAuth.login');
    }

    public function loginPost(Request $request)
    {
        $this->validate($request, [
            'userName' => 'required|string|min:4|max:255',
            'password' => 'required|string|min:8|max:255'
        ]);

        $auth = Auth::attempt([
            'userName' => $request->input('userName'),
            'password' => $request->input('password')
        ], 1);

        if (!$auth) {
            return redirect()->route('auth.login')->withErrors(['notCredentials' => 'نام کاربری یا رمز عبور اشتباه است'])->withInput();
        }

        if (auth()->user()->isAdmin) {
            return redirect()->to('/panel/admin/home');
        }
        return redirect()->to('/panel/user/home');
    }

    public function register()
    {
        return view('customAuth.register');
    }

    public function registerPost(Request $request)
    {
        $request->offsetSet('birthday',toGorgian($request->input('birthday')));

        $this->validate($request, [
            'skill_id' => 'required|numeric|exists:skills,id',
            'city_id' => 'required|numeric|exists:cities,id',

            'email' => 'required|string|email|min:8|max:255',
            'firstName' => 'required|string|min:2|max:255',
            'lastName' => 'required|string|min:2|max:255',
            'fatherName' => 'required|string|min:2|max:255',
            'gender' => 'required|in:male,female',
            'nationalCode' => [
                'required',
                new nationalCode(),
            ],
            'certificateCode' => 'required|digits_between:4,11',
            'postalCode' => 'required|digits_between:9,11',
            'birthday' => 'required|before:2005-01-01',
            'birthplace' => 'required|string|min:4|max:255',
            'mobile' => 'required|digits_between:10,11|unique:users,mobile',
            'telephone' => 'required|digits_between:10,11',
            'address' => 'required|string|min:4|max:2048',
            'education' => 'required|in:1,2,3,4,5,6',
            'fieldOfStudy' => 'required|string|min:4|max:255',
            'educationPicture' => 'nullable|mimes:jpeg,jpg,pdf,png|max:4096',
            'personalPicture' => 'nullable|mimes:jpeg,jpg,pdf,png|max:4096',
            'nationalCardPicture' => 'nullable|mimes:jpeg,jpg,pdf,png|max:4096',
            'password' => 'required|string|min:8|max:255',
        ]);


        $educationPicture = null;
        if ($request->hasFile('educationPicture')) {
            $educationPicture = $request->file('educationPicture')->store('uplaods/users');
        }

        $personalPicture = null;
        if ($request->hasFile('personalPicture')) {
            $personalPicture = $request->file('personalPicture')->store('uplaods/users');
        }

        $nationalCardPicture = null;
        if ($request->hasFile('nationalCardPicture')) {
            $nationalCardPicture = $request->file('nationalCardPicture')->store('uplaods/users');
        }


        $user = User::create([
            'userName' => $request->input('mobile'),
            'email' => $request->input('email'),
            'firstName' => $request->input('firstName'),
            'lastName' => $request->input('lastName'),
            'fatherName' => $request->input('fatherName'),
            'gender' => $request->input('gender'),
            'nationalCode' => $request->input('nationalCode'),
            'certificateCode' => $request->input('certificateCode'),
            'postalCode' => $request->input('postalCode'),
            'birthday' => $request->input('birthday'),
            'birthplace' => $request->input('birthplace'),
            'mobile' => $request->input('mobile'),
            'telephone' => $request->input('telephone'),
            'address' => $request->input('address'),
            'education' => $request->input('education'),
            'fieldOfStudy' => $request->input('fieldOfStudy'),
            'educationPicture' => $educationPicture,
            'personalPicture' => $personalPicture,
            'nationalCardPicture' => $nationalCardPicture,
            'api_token' => Str::random(64),
            'isActive' => 1,
            'isAdmin' => 0,
            'type' => 'user',
            'email_verified_at' => now(),
            'mobile_verified_at' => now(),
            'password' => bcrypt($request->input('password'))
        ]);


        $user->skill()->sync($request->input('skill_id'));
        auth()->loginUsingId($user->id);

        if (auth()->user()->isAdmin) {
            return redirect()->to('/panel/admin/home');
        }
        return redirect()->to('/panel/user/home');
    }

    public function logout()
    {
        auth()->logout();
        return redirect()->to('/');
    }
}
