<?php

namespace App\Http\Controllers\customAuth;

use App\Http\Controllers\Controller;
use App\Libraries\Rules\nationalCode;
use App\Models\Skill\skill;
use App\Models\User\userMobileVerify;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;

class loginController extends Controller
{

    public function login()
    {
        return view('customAuth.login');
    }

    public function loginPost(Request $request)
    {
        $this->validate($request, [
            'userName' => 'required|string|min:2|max:255',
            'password' => 'required|string|min:6|max:255'
        ]);

        $auth = Auth::attempt([
            'userName' => $request->input('userName'),
            'password' => $request->input('password')
        ], 1);

        if (!$auth) {
            return redirect()->route('auth.login')->withErrors(['notCredentials'=>'نام کاربری یا رمز عبور اشتباه است'])->withInput();
        }

        if (auth()->user()->isAdmin) {
            return redirect()->to('/panel/admin/home');
        }
        return redirect()->to('/panel/user/home');
    }

}
