<?php

namespace App\Http\Controllers\customAuth;

use App\Http\Controllers\Controller;
use App\Libraries\Rules\FarsiValidation;
use App\Libraries\Rules\nationalCode;
use App\Libraries\Rules\referalCode;
use App\Models\User\userMobileVerify;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class registerController extends Controller
{

    public function create()
    {
        return view('customAuth.Register.register');
    }

    public function store(Request $request)
    {
        $request->offsetSet('mobile', convertNumbers($request->input('mobile')));

        $this->validate($request, [
            'firstName' => [
                'required',
                'string',
                'min:2',
                'max:255',
                new FarsiValidation(),
            ],
            'lastName' => [
                'required',
                'string',
                'min:2',
                'max:255',
                new FarsiValidation(),
            ],
            'email' => 'required|string|email|min:2|max:255|unique:users,email',
            'mobile' => 'required|string|digits_between:9,11|unique:users,mobile',
            'referalCode' => [
                'nullable',
                new referalCode(),
            ],
            'nationalCode' => [
                'required',
                'numeric',
                new nationalCode(),
            ],
            'password' => 'required|string|min:8|max:255|confirmed',
        ]);


        $user = User::create([
            'userName' => $request->input('mobile'),
            'email' => $request->input('email'),
            'firstName' => $request->input('firstName'),
            'lastName' => $request->input('lastName'),
            'nationalCode' => $request->input('nationalCode'),
            'mobile' => $request->input('mobile'),
            'api_token' => Str::random(64),
            'isPay' => 0,
            'isActive' => 0,
            'isAdmin' => 0,
            'type' => 'user',
            'email_verified_at' => now(),
            'mobile_verified_at' => now(),
            'password' => bcrypt($request->input('password'))
        ]);


        $user->wallet()->create([
            'withdraw' => 0,
            'deposit' => 0,
            'amount' => 0,
            'status' => 1
        ]);


        if (session('refCode')) {
            $user->update([
                'ref' => session('refCode'),
            ]);
            session()->forget('refCode');
        } else {
            $user->update([
                'ref' => referalCode($request->input('referalCode'))['organization_id'],
            ]);
        }




        auth()->loginUsingId($user->id);
        return redirect()->route('auth.confirm.sms');
    }

}
