<?php

namespace App\Libraries\Classes\gateway;

use App\Models\Order\order;
use kipolaboratory\KipoPay\KipoKPG;

class Kipo
{
    protected static $instance;

    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    public function send(order $order)
    {
        $kipo = new KipoKPG(['merchant_key' => '09082001173']);
        $kpg_initiate = $kipo->KPGInitiate($order->price * 10, route('payment.verify', $order->transaction()->where('status', 'pending')->first()->pin));
        if (isset($kpg_initiate['status']) && $kpg_initiate['status']) {
            session(['kipo_key' => $kpg_initiate['shopping_key']]);
            $kipo->renderForm($kpg_initiate['shopping_key']);
        } else {
            return false;
        }
    }


    public function verify()
    {
        $result = [
            'code' => 0,
            'status' => 'error'
        ];
        $kipo = new KipoKPG(['merchant_key' => '09082001173']);
        if (request()->input('status') == true) {
            try {

                $kpg_inquery = $kipo->KPGInquery(request()->input('pt'));
                if ($kpg_inquery['status'] == true && isset($kpg_inquery['referent_code'])) {
                    $refCode = $kpg_inquery['referent_code'];
                    $result = [
                        'status' => 'success',
                        'code' => $refCode,
                    ];
                } else {
                    $result = [
                        'status' => 'error',
                        'code' => 1,
                        'message' => 'referent_code not found'
                    ];
                }
            } catch (\Throwable $throwable) {
                $result = [
                    'code' => 2,
                    'status' => 'error',
                    'message' => $throwable->getMessage(),
                ];
            }
        }
        else {
            $result = [
                'code' => 3,
                'status' => 'error',
                'message' => 'canceled'
            ];
        }

        return $result;
    }
}
