<?php

namespace App\Models\Acl;

use Illuminate\Database\Eloquent\Model;

class permission extends Model
{
    protected $fillable = [
        'name',
        'label',
        'group',
        'mainGroup'
    ];


    // Relations

    public function role()
    {
        return $this->belongsToMany(role::class);
    }


    // Scopes

    public function scopeSearch($query)
    {
        $request = request();
        $result  = $request->only(array_merge($this->getFillable(),['id']));
        foreach ($result as $key => $value) {
            $query->orderBy($key,$value);
        }


        $query->where(function ($query) use ($request) {
            if ($request->has('query')) {
                $query->orWhere('id', 'like', "%{$request->input('query')}%");
                $query->orWhere('name', 'like', "%{$request->input('query')}%");
                $query->orWhere('label', 'like', "%{$request->input('query')}%");
            }
        });

        return $query;
    }

}
