<?php

namespace App\Models\Acl;

use App\User;
use Illuminate\Database\Eloquent\Model;

class role extends Model
{
    protected $fillable = ['name','label'];


    // Relations

    public function permissions()
    {
        return $this->belongsToMany(permission::class)->withTimestamps();
    }

    public function user()
    {
        return $this->belongsToMany(User::class);
    }

    public function givePermissionTo(permission $permission)
    {
        return $this->permissions()->save($permission);
    }


    // Scopes

    public function scopeSearch($query)
    {
        $request = request();
        $result  = $request->only(array_merge($this->getFillable(),['id']));
        foreach ($result as $key => $value) {
            $query->orderBy($key,$value);
        }

        if ($request->has('query')) {
            $query->orWhere('label','like', "%{$request->input('query')}%");
            $query->orWhere('id','like', "%{$request->input('query')}%");
        }

        return $query;
    }

}
