<?php

namespace App\Models\Order;

use App\User;
use Illuminate\Database\Eloquent\Model;

class order extends Model
{
    protected $fillable = [
        'user_id',
        'sendCost',
        'sendCode',
        'sendType',
        'sendStatus',
        'payCode',
        'payRefNumber',
        'payType',
        'payStatus',
        'weight',
        'price',
        'description',
        'currency',
        'type',
        'status'
    ];
    protected $appends = ['payTypeTranslate', 'statusPayTranslate', 'statusTranslate'];


    // Relations

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function orderItem()
    {
        return $this->hasMany(orderItem::class);
    }

    public function transaction()
    {
        return $this->hasMany(transaction::class);
    }

    public function orderLabel()
    {
        return $this->belongsToMany(orderLabel::class, 'orderLabel_order');
    }


    // Scoeps

    public function scopeSearch($query)
    {
        $request = request();
        $fillables = array_merge($this->getFillable(), ['id']);

        $query->where(function ($query) use ($request, $fillables) {

            foreach ($request->all() as $key => $value) {
                if (str_contains($key, 'orderby') && (array_search($keyResult = str_replace('orderby_', '', $key), $fillables) !== false)) {
                    $query->orderBy($keyResult, $value);
                } elseif (array_search($key, $fillables) !== false) {
                    $query->where($key, $value);
                } elseif (str_contains($key, 'like') && (array_search($keyResult = str_replace('like_', '', $key), $fillables) !== false)) {
                    $query->orWhere($keyResult, 'like', "%{$value}%");
                }
            }


            if ($request->has('query')) {
                $query->orWhere('id', 'like', "%{$request->input('query')}%");
            }

        });

        if ($request->input('withuser',0) == 1) {
            $query->with('user:id,email,firstName,lastName');
        }

        return $query;
    }

    public function scopeOwn($query)
    {
        $query->where('user_id', auth()->user()->id);
    }

    public function scopeCanPay($query)
    {
        return $query->where('finalPrice','>',0)->where(function ($query) {
            $query->orWhereNull('statusPay')->orWhere('statusPay', 'error');
        });
    }


    // Extra Methods

    public function getPayTypeTranslateAttribute()
    {
        if ($this->payType == null) {
            return trans('Financial::general.labels.unkown');
        } elseif ($this->payType == 'receipt') {
            return trans('Financial::general.labels.receipt');
        } elseif ($this->payType == 'homepay') {
            return trans('Financial::general.labels.homepay');
        } elseif ($this->payType == 'crypto') {
            return trans('Financial::general.labels.crypto');
        } elseif ($this->payType == 'gateway') {
            return trans('Financial::general.labels.gateway');
        }

        return $this->payType;
    }

    public function getStatusTranslateAttribute()
    {
        if ($this->status == 'success') {
            return trans('Financial::general.labels.successDelivery');
        } elseif ($this->status == null) {
            return trans('Financial::general.labels.unpay');
        } elseif ($this->status == 'error') {
            return trans('Financial::general.labels.errorDelivery');
        } elseif ($this->status == 'pending') {
            return trans('Financial::general.labels.pending');
        }

        return $this->status;
    }

    public function getStatusPayTranslateAttribute()
    {
        if ($this->statusPay == 'success') {
            return trans('Financial::general.labels.success');
        } elseif ($this->statusPay == 'pending') {
            return trans('Financial::general.labels.pending');
        } elseif ($this->statusPay == 'unsuccess') {
            return trans('Financial::general.labels.unsuccess');
        } elseif ($this->statusPay == null) {
            return trans('Financial::general.labels.unpay');
        }

        return $this->statusPay;
    }

}
