<?php

namespace App\Models\Order;

use App\User;
use Illuminate\Database\Eloquent\Model;


class transaction extends Model
{
    protected $fillable = [
        'order_id',
        'user_id',
        'gateway_id',
        'gatewayType',
        'pin',
        'body',
        'device',
        'ip',
        'browser',
        'browserVersion',
        'os',
        'osVersion',
        'refNumber',
        'price',
        'statusGateway',
        'status'
    ];
    protected $appends = ['statusTranslate'];

    // Relations

    public function gateway()
    {
        return $this->belongsTo(gateway::class);
    }

    public function order()
    {
        return $this->belongsTo(order::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }


    // Scoeps

    public function scopeSearch($query)
    {
        $request = request();
        $fillables = array_merge($this->getFillable(), ['id']);

        $query->where(function ($query) use ($request, $fillables) {

            foreach ($request->all() as $key => $value) {
                if (str_contains($key, 'orderby') && (array_search($keyResult = str_replace('orderby_', '', $key), $fillables) !== false)) {
                    $query->orderBy($keyResult, $value);
                } elseif (array_search($key, $fillables) !== false) {
                    $query->where($key, $value);
                } elseif (str_contains($key, 'like') && (array_search($keyResult = str_replace('like_', '', $key), $fillables) !== false)) {
                    $query->orWhere($keyResult, 'like', "%{$value}%");
                }
            }


            if ($request->input('query',null)) {
                $query->orWhere('id', 'like', "%{$request->input('query')}%");
                $query->orWhere('invoice_id', 'like', "%{$request->input('query')}%");
                $query->orWhere('user_id', 'like', "%{$request->input('query')}%");
            }

        });


        return $query;
    }


    // Extra Methods

    public function getStatusTranslateAttribute()
    {
        if ($this->status == 'success') {
            return 'موفق';
        } elseif ($this->status == null) {
            return 'پرداخت نشده';
        }

        return $this->status;
    }

}
