<?php

namespace App\Models\Organization;

use App\Http\Libraries\Traits\Tree;
use App\Models\Wallet\Wallet;
use App\User;
use Illuminate\Database\Eloquent\Model;

class organization extends Model
{
    use Tree;

    protected $fillable = [
        'title',
        'parent_id',
        'code',
        'body',
        'logo',
        'picture',
        'status'
    ];


    // Relations

    public function admins()
    {
        return $this->belongsToMany(User::class, 'organization_admin')->withTimestamps();
    }

    public function userReferal()
    {
        return $this->belongsToMany(User::class, 'referalCode_organization')->withTimestamps();
    }

    public function wallet()
    {
        return $this->morphOne(Wallet::class, 'model');
    }


    // Scoeps

    public function scopeSearch($query)
    {
        $request = request();
        $fillables = array_merge($this->getFillable(), ['id']);
        foreach ($request->all() as $key => $value) {
            if (str_contains($key, 'orderby') && (array_search($keyResult = str_replace('orderby_', '', $key), $fillables) !== false)) {
                $query->orderBy($keyResult, $value);
            }
        }

        $query->where(function ($query) use ($request,$fillables) {
            foreach ($request->all() as $key => $value) {
                if (array_search($key, $fillables) !== false) {
                    $query->where($key, $value);
                } elseif (str_contains($key, 'like') && (array_search($keyResult = str_replace('like_', '', $key), $fillables) !== false)) {
                    $query->where($keyResult, 'like', "%{$value}%");
                }
            }

            if ($request->has('query')) {
                $query->orWhere('id', 'like', "%{$request->input('query')}%");
                $query->orWhere('title', 'like', "%{$request->input('query')}%");
            }

        });

        return $query;
    }


}
