<?php

namespace App\Models\Region;

use Illuminate\Database\Eloquent\Model;

class area extends Model
{
    protected $fillable = [
        'title',
        'city_id',
        'latitude',
        'order',
        'status'
    ];

    public function city()
    {
        return $this->belongsTo(city::class);
    }


    // scopes

    public function scopeSearch($query)
    {
        $request = request();
        $fillables = array_merge($this->getFillable(), ['id', 'cities_count']);

        $query->where(function ($query) use ($request, $fillables) {

            foreach ($request->all() as $key => $value) {
                if (str_contains($key, 'orderby') && (array_search($keyResult = str_replace('orderby_', '', $key), $fillables) !== false)) {
                    $query->orderBy($keyResult, $value);
                } elseif (array_search($key, $fillables) !== false) {
                    $query->where($key, $value);
                } elseif (str_contains($key, 'like') && (array_search($keyResult = str_replace('like_', '', $key), $fillables) !== false)) {
                    $query->orWhere($keyResult, 'like', "%{$value}%");
                }
            }


            if ($request->has('query')) {
                $query->orWhere('id', 'like', "%{$request->input('query')}%");
                $query->orWhere('title', 'like', "%{$request->input('query')}%");
            }

        });


        if (is_array($request->input('city_id'))) {
            $query->WhereIn('city_id', $request->input('city_id'));
        }

        if ($request->has('city_title')) {
            $query->orWhereHas('city', function ($query) use ($request) {
                $query->Where('cities.title', 'like', "%{$request->input('city_title')}%");
            });
        }

        if ($request->input('withcity',0) == 1) {
            $query->with('city');
        }

        return $query;
    }

    public function scopeValidate($query)
    {
        return $query;
    }
}
