<?php

namespace App\Models\Region;

use App\User;
use Illuminate\Database\Eloquent\Model;

class city extends Model
{
    protected $fillable = [
        'title',
        'state_id',
        'latitude',
        'order',
        'status'
    ];

    public function area()
    {
        return $this->hasMany(area::class);
    }

    public function state()
    {
        return $this->belongsTo(state::class);
    }

    public function user()
    {
        return $this->hasMany(User::class);
    }


    // Scopes

    public function scopeSearch($query)
    {
        $request = request();
        $fillables = array_merge($this->getFillable(), ['id', 'cities_count']);
        $query->where(function ($query) use ($request, $fillables) {

            foreach ($request->all() as $key => $value) {
                if (str_contains($key, 'orderby') && (array_search($keyResult = str_replace('orderby_', '', $key), $fillables) !== false)) {
                    $query->orderBy($keyResult, $value);
                } elseif (array_search($key, $fillables) !== false) {
                    $query->where($key, $value);
                } elseif (str_contains($key, 'like') && (array_search($keyResult = str_replace('like_', '', $key), $fillables) !== false)) {
                    $query->orWhere($keyResult, 'like', "%{$value}%");
                }
            }


            if ($request->has('query')) {
                $query->orWhere('id', 'like', "%{$request->input('query')}%");
                $query->orWhere('title', 'like', "%{$request->input('query')}%");
            }

        });

        if ($request->has('state')) {
            if (is_array($request->input('state'))) {
                $query->whereIn('state_id',$request->input('state'));
            } else {
                $query->where('state_id',$request->input('state'));
            }
        }

        if ($request->has('state_title')) {
            $query->orWhereHas('state', function ($query) use ($request) {
                $query->Where('states.title', 'like', "%{$request->input('state_title')}%");
            });
        }

        if ($request->has('area_id') || $request->has('area_title')) {
            $query->orWhereHas('area', function ($query) use ($request) {

                if ($request->has('area_title')) {
                    $query->Where('areas.title', 'like', "%{$request->input('area_title')}%");
                }

                if (is_array($request->input('area_id'))) {
                    $query->WhereIn('areas.id', $request->input('area_id'));
                }

            });
        }

        if ($request->input('withstate',0) == 1) {
            $query->with('state');
        }

        if ($request->input('witharea',0) == 1) {
            $query->with('state');
        }

        return $query;
    }

    public function scopeValidate($query)
    {
        return $query->where('status', 1);;
    }

}
