<?php

namespace App\Models\Region;

use Illuminate\Database\Eloquent\Model;

class state extends Model
{
    protected $fillable = [
        'country_id',
        'title',
        'latitude',
        'order',
        'status'
    ];

    public function country()
    {
        return $this->belongsTo(country::class);
    }

    public function city()
    {
        return $this->hasMany(city::class);
    }


    // Scopes

    public function scopeSearch($query)
    {
        $request = request();
        $fillables = array_merge($this->getFillable(), ['id', 'cities_count']);

        $query->where(function ($query) use ($request, $fillables) {

            foreach ($request->all() as $key => $value) {
                if (str_contains($key, 'orderby') && (array_search($keyResult = str_replace('orderby_', '', $key), $fillables) !== false)) {
                    $query->orderBy($keyResult, $value);
                } elseif (array_search($key, $fillables) !== false) {
                    $query->where($key, $value);
                } elseif (str_contains($key, 'like') && (array_search($keyResult = str_replace('like_', '', $key), $fillables) !== false)) {
                    $query->orWhere($keyResult, 'like', "%{$value}%");
                }
            }


            if ($request->has('query')) {
                $query->orWhere('id', 'like', "%{$request->input('query')}%");
                $query->orWhere('title', 'like', "%{$request->input('query')}%");
            }

        });


        if (is_array($request->input('country_id'))) {
            $query->WhereIn('country_id', $request->input('country_id'));
        }

        if (is_array($request->input('city_id'))) {
            $query->whereHas('city', function ($query) {
                $query->where('cities.id', request()->input('city_id'));
            });
        }


        if ($request->input('withcountry') == 1) {
            $query->with('country');
        }

        return $query;
    }

    public function scopeValidate($query)
    {
        return $query->where('status', 1);
    }


    //  Map Code

    public function mapCode()
    {

        if ($this->id == 1) {
            return 'IRN3238';
        } elseif ($this->id == 2) {
            return 'IRN3237';
        } elseif ($this->id == 3) {
            return 'IRN3230';
        } elseif ($this->id == 4) {
            return 'IRN3211';
        } elseif ($this->id == 5) {
            return 'IRN5490 ';
        } elseif ($this->id == 6) {
            return 'IRN3221 ';
        } elseif ($this->id == 7) {
            return 'IRN3210 ';
        } elseif ($this->id == 8) {
            return 'IRN3216 ';
        } elseif ($this->id == 9) {
            return 'IRN3218 ';
        } elseif ($this->id == 10) {
            return 'IRN3244 ';
        } elseif ($this->id == 11) {
            return 'IRN3245 ';
        } elseif ($this->id == 12) {
            return 'IRN3246 ';
        } elseif ($this->id == 13) {
            return 'IRN3219 ';
        } elseif ($this->id == 14) {
            return 'IRN3234 ';
        } elseif ($this->id == 15) {
            return 'IRN3215 ';
        } elseif ($this->id == 16) {
            return 'IRN3247 ';
        } elseif ($this->id == 17) {
            return 'IRN3212 ';
        } elseif ($this->id == 18) {
            return 'IRN3235 ';
        } elseif ($this->id == 19) {
            return 'IRN3235 ';
        } elseif ($this->id == 20) {
            return 'IRN3241 ';
        } elseif ($this->id == 21) {
            return 'IRN3248 ';
        } elseif ($this->id == 22) {
            return 'IRN3239 ';
        } elseif ($this->id == 23) {
            return 'IRN3209 ';
        } elseif ($this->id == 24) {
            return 'IRN3213 ';
        } elseif ($this->id == 25) {
            return 'IRN3240 ';
        } elseif ($this->id == 26) {
            return 'IRN3220 ';
        } elseif ($this->id == 27) {
            return 'IRN3214 ';
        } elseif ($this->id == 28) {
            return 'IRN3231 ';
        } elseif ($this->id == 29) {
            return 'IRN3228 ';
        } elseif ($this->id == 30) {
            return 'IRN3233 ';
        } elseif ($this->id == 31) {
            return 'IRN3217 ';
        } else {
            return 'IRN3217 ';
        }


    }
}
