<?php

namespace App\Models\Service;

use Illuminate\Database\Eloquent\Model;

class serviceCategory extends Model
{
    protected $fillable = [
        'title',
        'body',
        'picture',
        'status'
    ];

    protected $appends = ['pictureApi'];

    // Relations

    public function department()
    {
        return $this->belongsToMany(serviceDepartment::class,'serviceDepartment_serviceCategory');
    }

    public function offer()
    {
        return $this->belongsToMany(serviceOffer::class,'serviceCategory_serviceOffer');
    }


    // Scopes

    public function scopeSearch($query)
    {
        $request = request();
        $fillables = array_merge($this->getFillable(), ['id']);
        foreach ($request->all() as $key => $value) {
            if (str_contains($key, 'orderby') && (array_search($keyResult = str_replace('orderby_', '', $key), $fillables) !== false)) {
                $query->orderBy($keyResult, $value);
            }
        }

        $query->where(function ($query) use ($request,$fillables) {
            foreach ($request->all() as $key => $value) {
                if (array_search($key, $fillables) !== false) {
                    if ($key != 'api_token') {
                        $query->where($key, $value);
                    }
                } elseif (str_contains($key,'like') && (array_search($keyResult = str_replace('like_', '', $key), $fillables) !== false)) {
                    $query->where($keyResult, 'like', "%{$value}%");
                }
            }

            if ($request->has('query')) {
                $query->orWhere('id', 'like', "%{$request->input('query')}%");
                $query->orWhere('title', 'like', "%{$request->input('query')}%");
            }

            if ($request->has('date_start')) {
                $query->whereDate('created_at', '>=', "{$request->input('start')}");
            }

            if ($request->has('date_end')) {
                $query->whereDate('created_at', '<=', "{$request->input('end')}");
            }

        });

        return $query;
    }


    public function scopeValidate($query)
    {
        return $query->where('status',1);
    }


    // Attributes

    public function getPictureApiAttribute()
    {
        if ($this->picture) {
            return asset($this->picture);
        } else {
            return asset('assets/img/default.jpg');
        }
    }




    // get Attibutes

    public function moppon()
    {

        if ($this->id == 28) {
            return 'zQoGQ';
        } elseif ($this->id == 24) {
            return 'mBDnQ';
        } elseif ($this->id == 29) {
            return 'NlydQ';
        } elseif ($this->id == 21) {
            return 'KBYXl';
        } elseif ($this->id == 14) {
            return 'pgEDB';
        } elseif ($this->id == 23) {
            return 'pgEDB';
        } elseif ($this->id == 39) {
            return 'JBGDg';
        } elseif ($this->id == 0000) {
            return 'ygKml';
        } elseif ($this->id == 25) {
            return 'xBewQ';
        } elseif ($this->id == 31) {
            return 'qgMmg';
        } elseif ($this->id == 27) {
            return 'vBWOB';
        }

    }
}
