<?php

namespace App\Models\Service;

use Illuminate\Database\Eloquent\Model;

class serviceOfferClick extends Model
{
    protected $fillable = [
        'service_offer_id',
        'device',
        'ip',
        'browser',
        'browserVersion',
        'os',
        'osVersion'
    ];


    // Relations

    public function offer()
    {
        return $this->belongsTo(serviceOffer::class);
    }



    // Scopes

    public function scopeSearch($query)
    {
        $request = request();
        $fillables = array_merge($this->getFillable(), ['id']);
        foreach ($request->all() as $key => $value) {
            if (str_contains($key, 'orderby') && (array_search($keyResult = str_replace('orderby_', '', $key), $fillables) !== false)) {
                $query->orderBy($keyResult, $value);
            }
        }

        $query->where(function ($query) use ($request,$fillables) {
            foreach ($request->all() as $key => $value) {
                if (array_search($key, $fillables) !== false) {
                    if ($key != 'api_token') {
                        $query->where($key, $value);
                    }
                } elseif (str_contains($key,'like') && (array_search($keyResult = str_replace('like_', '', $key), $fillables) !== false)) {
                    $query->where($keyResult, 'like', "%{$value}%");
                }
            }

            if ($request->has('query')) {
                $query->orWhere('id', 'like', "%{$request->input('query')}%");
                $query->orWhere('device', 'like', "%{$request->input('query')}%");
                $query->orWhere('ip', 'like', "%{$request->input('query')}%");
                $query->orWhere('browser', 'like', "%{$request->input('query')}%");
                $query->orWhere('browserVersion', 'like', "%{$request->input('query')}%");
                $query->orWhere('os', 'like', "%{$request->input('query')}%");
                $query->orWhere('osVersion', 'like', "%{$request->input('query')}%");
            }

            if ($request->has('date_start')) {
                $query->whereDate('created_at', '>=', "{$request->input('start')}");
            }

            if ($request->has('date_end')) {
                $query->whereDate('created_at', '<=', "{$request->input('end')}");
            }

        });

        return $query;
    }
}
