<?php

namespace App\Models\Setting;

use Illuminate\Database\Eloquent\Model;

class settingCategoryAdmin extends Model
{
    protected $fillable = [
        'title',
        'order',
        'type',
        'status'
    ];


    // Relations

    public function settingsAdmin()
    {
        return $this->hasMany(settingAdmin::class, 'category_id');
    }


    // Scopes

    public function scopeSearch($query)
    {
        $request = request();
        $fillables = array_merge($this->getFillable(), ['id','settings_admin_count']);

        $query->where(function ($query) use ($request, $fillables) {

            foreach ($request->all() as $key => $value) {
                if (str_contains($key, 'orderby') && (array_search($keyResult = str_replace('orderby_', '', $key), $fillables) !== false)) {
                    $query->orderBy($keyResult, $value);
                } elseif (array_search($key, $fillables) !== false) {
                    $query->where($key, $value);
                } elseif (str_contains($key, 'like') && (array_search($keyResult = str_replace('like_', '', $key), $fillables) !== false)) {
                    $query->orWhere($keyResult, 'like', "%{$value}%");
                }
            }


            if ($request->has('query')) {
                $query->orWhere('id', 'like', "%{$request->input('query')}%");
                $query->orWhere('title', 'like', "%{$request->input('query')}%");
            }

        });


        return $query;
    }

    public function scopeValidate($query)
    {
        return $query->where('status',1);
    }
}
