<?php

namespace App\Models\Setting;

use Illuminate\Database\Eloquent\Model;

class settingMain extends Model
{
    protected $fillable = [
        'settingAdmin_id',
        'value',
        'link'
    ];


    // Relations

    public function category()
    {
        return $this->belongsTo(settingAdmin::class,'settingAdmin_id');
    }


    // Scopes

    public function scopeCache()
    {
        $list = $this->join('setting_admins','setting_mains.settingAdmin_id','=','setting_admins.id')
            ->select('setting_mains.id','setting_mains.value','setting_mains.link','setting_admins.title','setting_admins.name','setting_admins.type','setting_mains.created_at','setting_mains.updated_at')
            ->get();
        cache()->forever('setting_mains',$list);

        return cache('setting_mains');
    }

    public function scopeSearch($query,$request)
    {
        $result  = $request->intersect(array_merge($this->getFillable(),['id']));
        foreach ($result as $key => $value) {
            $query->orderBy($key,$value);
        }

        if ($request->has('query')) {
            $query->orWhere('id','like', "%{$request->input('query')}%");
            $query->orWhere('value','like',"%{$request->input('query')}%");
            $query->orWhere('settingAdmin_id','like',"%{$request->input('query')}%");
        }

        return $query;
    }
}
