<?php

namespace App\Models\Ticket;

use App\User;
use Illuminate\Database\Eloquent\Model;

class ticket extends Model
{

    public $fillable = [
        'ticketDepartment_id',
        'user_id',
        'title',
        'prority',
        'body',
        'isRead',
        'pathFile',
        'isRead',
        'status'
    ];


    // Relations

    public function department()
    {
        return $this->belongsTo(ticketDepartment::class,'ticketDepartment_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function referer()
    {
        return $this->belongsToMany(User::class, 'ticket_refers');
    }

    public function messages()
    {
        return $this->hasMany(ticketMessage::class);
    }


    // Scopes

    public function scopeSearch($query)
    {
        $request = request();
        $fillables = array_merge($this->getFillable(), ['id']);
        foreach ($request->all() as $key => $value) {
            if (str_contains($key, 'orderby') && (array_search($keyResult = str_replace('orderby_', '', $key), $fillables) !== false)) {
                $query->orderBy($keyResult, $value);
            }
        }

        $query->where(function ($query) use ($request,$fillables) {
            foreach ($request->all() as $key => $value) {
                if (array_search($key, $fillables) !== false) {
                    $query->where($key, $value);
                } elseif (str_contains($key,'like') && (array_search($keyResult = str_replace('like_', '', $key), $fillables) !== false)) {
                    $query->where($keyResult, 'like', "%{$value}%");
                }
            }

            if ($request->has('query')) {
                $query->orWhere('id', 'like', "%{$request->input('query')}%");
                $query->orWhere('ticketDepartment_id', 'like', "%{$request->input('query')}%");
                $query->orWhere('user_id', 'like', "%{$request->input('query')}%");
                $query->orWhere('title', 'like', "%{$request->input('query')}%");
                $query->orWhere('body', 'like', "%{$request->input('query')}%");
            }

            if ($request->has('date_start')) {
                $query->whereDate('created_at', '>=', "{$request->input('start')}");
            }

            if ($request->has('date_end')) {
                $query->whereDate('created_at', '<=', "{$request->input('end')}");
            }

            $query->whereHas('user', function ($query) {
                $query->search();
            });

        });

        return $query;
    }


    public function scopeValidate($query)
    {
        return $query->where('status','<>', 'deactive');
    }


    public function scopeOwn($query)
    {
        return $query->where('user_id',auth()->user()->id);
    }

    public function scopeUnRead($query)
    {
        return $query->where('user_id',auth()->user()->id)->whereNull('isRead');
    }
}
