<?php

namespace App\Models\Ticket;

use Illuminate\Database\Eloquent\Model;

class ticketDepartment extends Model
{

    protected $fillable = [
        'title',
        'order',
        'picture',
        'status'
    ];


    // Relations

    public function tickets()
    {
        return $this->hasMany(ticket::class,'ticketDepartment_id');
    }


    // Scopes

    public function scopeSearch($query)
    {
        $request = request();
        $result = $request->only(array_merge($this->getFillable(), ['id']));
        foreach ($result as $key => $value) {
            $query->orderBy($key, $value);
        }

        if ($request->has('query')) {
            $query->orWhere('id', 'like', "%{$request->input('query')}%");
            $query->orWhere('amount', 'like', "%{$request->input('query')}%");
        }
        return $query;
    }

    public function scopeValidate($query)
    {
        return $query->where('status', 1);
    }
}
