<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAcademyTypesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('academy_types', function (Blueprint $table) {
            $table->bigIncrements('id')->index();

            $table->string('title')->nullable();
            $table->string('body', 4096)->nullable();
            $table->string('logo')->nullable();
            $table->string('picture')->nullable();
            $table->boolean('status');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('academy_types');
    }
}
