<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAgentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('agents', function (Blueprint $table) {
            $table->bigIncrements('id')->index();

            $table->unsignedBigInteger('user_id')->index();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            $table->string('title', 1024)->nullable();
            $table->string('email', 512)->nullable();
            $table->string('fax', 32)->nullable();
            $table->string('website', 512)->nullable();
            $table->string('telephone', 16)->nullable();
            $table->string('address', 2048)->nullable();
            $table->string('postalCode', 32)->nullable();
            $table->string('telegram')->nullable();
            $table->string('whatsapp', 32)->nullable();
            $table->string('cereficate')->nullable();
            $table->string('body', 4096)->nullable();
            $table->string('referalCode', 32)->nullable();
            $table->string('logo')->nullable();
            $table->string('picture')->nullable();
            $table->double('payPrice')->default(0);
            $table->boolean('payStatus')->nullable();
            $table->boolean('status')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('agents');
    }
}
