<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->bigIncrements('id')->index();

            $table->unsignedBigInteger('user_id');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            $table->double('sendCost')->default(0);
            $table->string('sendCode')->nullable();
            $table->string('sendType', 16)->nullable();
            $table->string('sendStatus', 16)->nullable();

            $table->string('payCode')->nullable()->index();
            $table->string('payRefNumber')->nullable()->index();
            $table->string('payType', 16)->nullable()->index();
            $table->string('payStatus', 16)->nullable()->index();

            $table->integer('weight')->default(0)->index();
            $table->double('price')->default(0)->index();
            $table->string('description', 512)->nullable();
            $table->string('currency', 16)->nullable();
            $table->string('type', 16)->nullable()->index();
            $table->string('status', 16)->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
}
