<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateServiceOffersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('service_offers', function (Blueprint $table) {
            $table->bigIncrements('id')->index();

            $table->string('title')->nullable();
            $table->string('code')->nullable();
            $table->string('link', 4096)->nullable();
            $table->double('clicks')->default(0);
            $table->text('body')->nullable();
            $table->string('type', 32)->nullable();
            $table->string('picture')->nullable();
            $table->dateTime('expire')->nullable();
            $table->boolean('status')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('service_offers');
    }
}
