<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateServiceCategoryServiceOffferTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('serviceCategory_serviceOffer', function (Blueprint $table) {
            $table->bigIncrements('id')->index();

            $table->unsignedBigInteger('service_offer_id')->index();
            $table->foreign('service_offer_id')->references('id')->on('service_offers')->onDelete('cascade');

            $table->unsignedBigInteger('service_category_id')->index();
            $table->foreign('service_category_id')->references('id')->on('service_categories')->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('serviceCategory_serviceOffer');
    }
}
