<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateServiceOfferClicksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('service_offer_clicks', function (Blueprint $table) {
            $table->bigIncrements('id')->index();

            $table->unsignedBigInteger('service_offer_id')->index();
            $table->foreign('service_offer_id')->references('id')->on('service_offers')->onDelete('cascade');

            $table->string('device')->nullable();
            $table->string('ip',32)->nullable();
            $table->string('browser',32)->nullable();
            $table->string('browserVersion',32)->nullable();
            $table->string('os',32)->nullable();
            $table->string('osVersion',32)->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('service_offer_clicks');
    }
}
