<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSettingCategoryAdminsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('setting_category_admins', function (Blueprint $table) {
            $table->bigIncrements('id')->index();

            $table->string('title')->nullable();
            $table->integer('order')->default(0);
            $table->enum('type',['default','main','user'])->default('default');
            $table->boolean('status')->default(1);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('setting_category_admins');
    }
}
