<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSettingMainsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('setting_mains', function (Blueprint $table) {
            $table->bigIncrements('id')->index();

            $table->unsignedBigInteger('settingAdmin_id');
            $table->foreign('settingAdmin_id')->references('id')->on('setting_admins')->onDelete('cascade');

            $table->string('value', 1024)->nullable();
            $table->string('link', 1024)->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('setting_mains');
    }
}
