<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateWalletTransactionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('wallet_transactions', function (Blueprint $table) {
            $table->bigIncrements('id')->index();

            $table->unsignedBigInteger('wallet_id')->index();
            $table->foreign('wallet_id')->references('id')->on('wallets')->onDelete('cascade');

            $table->double('amount')->nullable();
            $table->string('body',4096)->nullable();
            $table->string('type', 32)->nullable();
            $table->string('editedBy', 512)->nullable();
            $table->boolean('status')->default(0);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('wallet_transactions');
    }
}
