<?php

use App\Models\Acl\permission;
use App\Models\Acl\role;
use App\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class aclTableSeeder extends Seeder
{

    public function run()
    {
        $root = User::where('email','root')->first();
        $roleRoot  = role::where('label','programmer')->first();
        if (!isset($root->userName)) {
            $root = User::create([
                'email'      => 'root',
                'userName'   => 'root',
                'firstName'  => 'root',
                'lastName'   => 'root',
                'isActive'   => 1,
                'isAdmin'    => 1,
                'type'       => 'admin',
                'api_token'  => Str::random(64),
                'password'   => bcrypt('rootsecret'),
            ]);
        }
        if (!isset($roleRoot->name)) {
            $roleRoot = role::create([
                'name'=> 'برنامه نویس',
                'label'=> 'programmer'
            ]);
        }
        $roleRoot->permissions()->sync(permission::select('id')->get()->pluck('id'));
        $root->role()->sync([$roleRoot->id]);


        $admin = User::where('email','admin')->first();
        $roleAdmin  = role::where('label','superuser')->first();
        if (!isset($admin->userName)) {
            $admin = User::create([
                'email'      => 'admin',
                'userName'   => 'admin',
                'firstName'  => 'admin',
                'lastName'   => 'admin',
                'isActive'   => 1,
                'isAdmin'    => 1,
                'type'       => 'admin',
                'api_token'  => Str::random(64),
                'password'   => bcrypt('adminsecret'),
            ]);
        }
        if (!isset($roleAdmin->name)) {
            $roleAdmin = role::create([
                'name'=> 'مدیر کل',
                'label'=> 'superuser'
            ]);
        }
        $roleAdmin->permissions()->sync(permission::select('id')->whereNotIn('id',range(1,14))->get()->pluck('id'));
        $admin->role()->sync([$roleAdmin->id]);

        cache()->forever('permission', permission::with('role')->get());
    }

}
