<?php

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class permissionsTableSeeder extends Seeder
{

    public function run()
    {
        $newPermissions = collect($this->getPermission());

        $dbPermissions  = DB::table('permissions')->select('id','name')->get();
        $removeItems = [];
        $addItems = [];

        foreach ($newPermissions as $newPermission) {
            if (!$dbPermissions->contains('name',$newPermission['name'])) {
                $addItems[] = $newPermission;
            }
        }
        foreach ($dbPermissions as $dbPermission) {
            if (!$newPermissions->contains('name',$dbPermission->name)) {
                $removeItems[] = $dbPermission;
            }
        }

        DB::table('permissions')->insert($addItems);
        DB::table('permissions')->whereIn('id',array_column($removeItems,'id'))->delete();

        cache()->forever('permissions',DB::table('permissions')->select('id','name')->get());
    }

    public function getPermission()
    {
        $permissions = [

            // ACL

            ['name'=>'role_index'   ,'label'=>'لیست نقش',   'group'=>'نقش' , 'mainGroup'=>'سطح دسترسی'],
            ['name'=>'role_store'   ,'label'=>'ایجاد نقش',  'group'=>'نقش' , 'mainGroup'=>'سطح دسترسی'],
            ['name'=>'role_show'    ,'label'=>'نمایش نقش',  'group'=>'نقش' , 'mainGroup'=>'سطح دسترسی'],
            ['name'=>'role_update'  ,'label'=>'ویرایش نقش', 'group'=>'نقش' , 'mainGroup'=>'سطح دسترسی'],
            ['name'=>'role_destroy' ,'label'=>'حذف نقش',    'group'=>'نقش' , 'mainGroup'=>'سطح دسترسی'],



            // setting

            ['name'=>'settingCat_index'   ,'label'=> 'لیست دسته بندی تنظیمات',   'group'=>'دسته بندی تنظیمات','mainGroup'=>'مدیریت تنظیمات'],
            ['name'=>'settingCat_store'   ,'label'=> 'ایجاد دسته بندی تنظیمات',  'group'=>'دسته بندی تنظیمات','mainGroup'=>'مدیریت تنظیمات'],
            ['name'=>'settingCat_show'    ,'label'=> 'نمایش دسته بندی تنظیمات',  'group'=>'دسته بندی تنظیمات','mainGroup'=>'مدیریت تنظیمات'],
            ['name'=>'settingCat_update'  ,'label'=> 'ویرایش دسته بندی تنظیمات', 'group'=>'دسته بندی تنظیمات','mainGroup'=>'مدیریت تنظیمات'],
            ['name'=>'settingCat_destroy' ,'label'=> 'حذف دسته بندی تنظیمات',    'group'=>'دسته بندی تنظیمات','mainGroup'=>'مدیریت تنظیمات'],

            ['name'=>'setting_index'   ,'label'=> 'لیست تنظیمات',   'group'=>'تنظیمات','mainGroup'=>'مدیریت تنظیمات'],
            ['name'=>'setting_store'   ,'label'=> 'ایجاد تنظیمات',  'group'=>'تنظیمات','mainGroup'=>'مدیریت تنظیمات'],
            ['name'=>'setting_show'    ,'label'=> 'نمایش تنظیمات',  'group'=>'تنظیمات','mainGroup'=>'مدیریت تنظیمات'],
            ['name'=>'setting_update'  ,'label'=> 'ویرایش تنظیمات', 'group'=>'تنظیمات','mainGroup'=>'مدیریت تنظیمات'],
            ['name'=>'setting_destroy' ,'label'=> 'حذف تنظیمات',    'group'=>'تنظیمات','mainGroup'=>'مدیریت تنظیمات'],

            ['name'=>'settingMain_index' ,'label'=> 'تنظیمات اصلی',  'group'=>'تنظیمات مدیران','mainGroup'=>'مدیریت تنظیمات'],
            ['name'=>'settingUser_index' ,'label'=> 'تنظیمات شخصی',  'group'=>'تنظیمات مدیران','mainGroup'=>'مدیریت تنظیمات'],
            ['name'=>'setting_index'     ,'label'=> 'تنظیمات کلی',    'group'=>'تنظیمات مدیران','mainGroup'=>'مدیریت تنظیمات'],


            // Ticket

            ['name'=>'ticketDepartment_index'   ,'label'=> 'لیست دپارتمان تیکت',   'group'=> 'مدیریت دپارتمان تیکت','mainGroup'=>'تیکت'],
            ['name'=>'ticketDepartment_store'   ,'label'=> 'ایجاد دپارتمان تیکت',  'group'=> 'مدیریت دپارتمان تیکت','mainGroup'=>'تیکت'],
            ['name'=>'ticketDepartment_show'    ,'label'=> 'نمایش دپارتمان تیکت',  'group'=> 'مدیریت دپارتمان تیکت','mainGroup'=>'تیکت'],
            ['name'=>'ticketDepartment_update'  ,'label'=> 'ویرایش دپارتمان تیکت', 'group'=> 'مدیریت دپارتمان تیکت','mainGroup'=>'تیکت'],
            ['name'=>'ticketDepartment_destroy' ,'label'=> 'حذف دپارتمان تیکت',    'group'=> 'مدیریت دپارتمان تیکت','mainGroup'=>'تیکت'],

            ['name'=>'ticketManage_index'   ,'label'=> 'لیست مدیریت تیکت',   'group'=>'مدیریت تیکت','mainGroup'=>'تیکت'],
            ['name'=>'ticketManage_store'   ,'label'=> 'ایجاد مدیریت تیکت',  'group'=>'مدیریت تیکت','mainGroup'=>'تیکت'],
            ['name'=>'ticketManage_show'    ,'label'=> 'نمایش مدیریت تیکت',  'group'=>'مدیریت تیکت','mainGroup'=>'تیکت'],
            ['name'=>'ticketManage_update'  ,'label'=> 'ویرایش مدیریت تیکت', 'group'=>'مدیریت تیکت','mainGroup'=>'تیکت'],
            ['name'=>'ticketManage_destroy' ,'label'=> 'حذف مدیریت تیکت',    'group'=>'مدیریت تیکت','mainGroup'=>'تیکت'],

            ['name'=>'ticketMessage_index'   ,'label'=> 'لیست تیکت',   'group'=>'تیکت','mainGroup'=>'تیکت'],
            ['name'=>'ticketMessage_store'   ,'label'=> 'ایجاد تیکت',  'group'=>'تیکت','mainGroup'=>'تیکت'],
            ['name'=>'ticketMessage_show'    ,'label'=> 'نمایش تیکت',  'group'=>'تیکت','mainGroup'=>'تیکت'],
            ['name'=>'ticketMessage_update'  ,'label'=> 'ویرایش تیکت', 'group'=>'تیکت','mainGroup'=>'تیکت'],
            ['name'=>'ticketMessage_destroy' ,'label'=> 'حذف تیکت',    'group'=>'تیکت','mainGroup'=>'تیکت'],


            // User

            ['name'=>'user_crud_index'   ,'label'=> 'لیست کاربر',   'group'=>'مدیریت کاربران','mainGroup'=>'مدیریت کاربران'],
            ['name'=>'user_crud_store'   ,'label'=> 'ایجاد کاربر',  'group'=>'مدیریت کاربران','mainGroup'=>'مدیریت کاربران'],
            ['name'=>'user_crud_show'    ,'label'=> 'نمایش کاربر',  'group'=>'مدیریت کاربران','mainGroup'=>'مدیریت کاربران'],
            ['name'=>'user_crud_update'  ,'label'=> 'ویرایش کاربر', 'group'=>'مدیریت کاربران','mainGroup'=>'مدیریت کاربران'],
            ['name'=>'user_crud_destroy' ,'label'=> 'حذف کاربر',    'group'=>'مدیریت کاربران','mainGroup'=>'مدیریت کاربران'],
            ['name'=>'user_crud_login' ,'label'=> 'لاگین کاربر',    'group'=>'مدیریت کاربران','mainGroup'=>'مدیریت کاربران'],
            ['name'=>'user_crud_changestatus' ,'label'=> 'تغییر وضعیت کاربر',    'group'=>'مدیریت کاربران','mainGroup'=>'مدیریت کاربران'],
            ['name'=>'own_store'   ,'label'=> 'ویرایش مشخصات',  'group'=>'ویرایش مشخصات','mainGroup'=>'مدیریت کاربران'],


            // Region

            ['name'=>'country_index'   ,'label'=> 'لیست کشور',   'group'=>'کشور','mainGroup'=>'مدیریت مناطق'],
            ['name'=>'country_store'   ,'label'=> 'ایجاد کشور',  'group'=>'کشور','mainGroup'=>'مدیریت مناطق'],
            ['name'=>'country_show'    ,'label'=> 'نمایش کشور',  'group'=>'کشور','mainGroup'=>'مدیریت مناطق'],
            ['name'=>'country_update'  ,'label'=> 'ویرایش کشور', 'group'=>'کشور','mainGroup'=>'مدیریت مناطق'],
            ['name'=>'country_destroy' ,'label'=> 'حذف کشور',    'group'=>'کشور','mainGroup'=>'مدیریت مناطق'],

            ['name'=>'state_index'   ,'label'=> 'لیست استان',   'group'=>'استان','mainGroup'=>'مدیریت مناطق'],
            ['name'=>'state_store'   ,'label'=> 'ایجاد استان',  'group'=>'استان','mainGroup'=>'مدیریت مناطق'],
            ['name'=>'state_show'    ,'label'=> 'نمایش استان',  'group'=>'استان','mainGroup'=>'مدیریت مناطق'],
            ['name'=>'state_update'  ,'label'=> 'ویرایش استان', 'group'=>'استان','mainGroup'=>'مدیریت مناطق'],
            ['name'=>'state_destroy' ,'label'=> 'حذف استان',    'group'=>'استان','mainGroup'=>'مدیریت مناطق'],

            ['name'=>'city_index'   ,'label'=> 'لیست شهر',   'group'=>'شهر','mainGroup'=>'مدیریت مناطق'],
            ['name'=>'city_store'   ,'label'=> 'ایجاد شهر',  'group'=>'شهر','mainGroup'=>'مدیریت مناطق'],
            ['name'=>'city_show'    ,'label'=> 'نمایش شهر',  'group'=>'شهر','mainGroup'=>'مدیریت مناطق'],
            ['name'=>'city_update'  ,'label'=> 'ویرایش شهر', 'group'=>'شهر','mainGroup'=>'مدیریت مناطق'],
            ['name'=>'city_destroy' ,'label'=> 'حذف شهر',    'group'=>'شهر','mainGroup'=>'مدیریت مناطق'],

            ['name'=>'area_index'   ,'label'=> 'لیست منطقه',   'group'=>'منطقه','mainGroup'=>'مدیریت مناطق'],
            ['name'=>'area_store'   ,'label'=> 'ایجاد منطقه',  'group'=>'منطقه','mainGroup'=>'مدیریت مناطق'],
            ['name'=>'area_show'    ,'label'=> 'نمایش منطقه',  'group'=>'منطقه','mainGroup'=>'مدیریت مناطق'],
            ['name'=>'area_update'  ,'label'=> 'ویرایش منطقه', 'group'=>'منطقه','mainGroup'=>'مدیریت مناطق'],
            ['name'=>'area_destroy' ,'label'=> 'حذف منطقه',    'group'=>'منطقه','mainGroup'=>'مدیریت مناطق'],


            // Service

            ['name'=>'serviceDepartment_index'   ,'label'=>'لیست دپارتمان ها',   'group'=>'مدیریت دپارتمان ها' , 'mainGroup'=>'خدمات'],
            ['name'=>'serviceDepartment_store'   ,'label'=>'ایجاد دپارتمان ها',  'group'=>'مدیریت دپارتمان ها' , 'mainGroup'=>'خدمات'],
            ['name'=>'serviceDepartment_show'    ,'label'=>'نمایش دپارتمان ها',  'group'=>'مدیریت دپارتمان ها' , 'mainGroup'=>'خدمات'],
            ['name'=>'serviceDepartment_update'  ,'label'=>'ویرایش دپارتمان ها', 'group'=>'مدیریت دپارتمان ها' , 'mainGroup'=>'خدمات'],
            ['name'=>'serviceDepartment_destroy' ,'label'=>'حذف دپارتمان ها',    'group'=>'مدیریت دپارتمان ها' , 'mainGroup'=>'خدمات'],

            ['name'=>'serviceCategory_index'   ,'label'=>'لیست دسته بندی ها',   'group'=>'مدیریت دسته بندی ها' , 'mainGroup'=>'خدمات'],
            ['name'=>'serviceCategory_store'   ,'label'=>'ایجاد دسته بندی ها',  'group'=>'مدیریت دسته بندی ها' , 'mainGroup'=>'خدمات'],
            ['name'=>'serviceCategory_show'    ,'label'=>'نمایش دسته بندی ها',  'group'=>'مدیریت دسته بندی ها' , 'mainGroup'=>'خدمات'],
            ['name'=>'serviceCategory_update'  ,'label'=>'ویرایش دسته بندی ها', 'group'=>'مدیریت دسته بندی ها' , 'mainGroup'=>'خدمات'],
            ['name'=>'serviceCategory_destroy' ,'label'=>'حذف دسته بندی ها',    'group'=>'مدیریت دسته بندی ها' , 'mainGroup'=>'خدمات'],

            ['name'=>'serviceOffer_index'   ,'label'=>'لیست تخفیف ها',   'group'=>'مدیریت تخفیف ها' , 'mainGroup'=>'خدمات'],
            ['name'=>'serviceOffer_store'   ,'label'=>'ایجاد تخفیف ها',  'group'=>'مدیریت تخفیف ها' , 'mainGroup'=>'خدمات'],
            ['name'=>'serviceOffer_show'    ,'label'=>'نمایش تخفیف ها',  'group'=>'مدیریت تخفیف ها' , 'mainGroup'=>'خدمات'],
            ['name'=>'serviceOffer_update'  ,'label'=>'ویرایش تخفیف ها', 'group'=>'مدیریت تخفیف ها' , 'mainGroup'=>'خدمات'],
            ['name'=>'serviceOffer_destroy' ,'label'=>'حذف تخفیف ها',    'group'=>'مدیریت تخفیف ها' , 'mainGroup'=>'خدمات'],

            ['name'=>'serviceCard_index'   ,'label'=>'لیست کارت ها',   'group'=>'مدیریت کارت ها' , 'mainGroup'=>'خدمات'],
            ['name'=>'serviceCard_store'   ,'label'=>'ایجاد کارت ها',  'group'=>'مدیریت کارت ها' , 'mainGroup'=>'خدمات'],
            ['name'=>'serviceCard_show'    ,'label'=>'نمایش کارت ها',  'group'=>'مدیریت کارت ها' , 'mainGroup'=>'خدمات'],
            ['name'=>'serviceCard_update'  ,'label'=>'ویرایش کارت ها', 'group'=>'مدیریت کارت ها' , 'mainGroup'=>'خدمات'],
            ['name'=>'serviceCard_destroy' ,'label'=>'حذف کارت ها',    'group'=>'مدیریت کارت ها' , 'mainGroup'=>'خدمات'],

            ['name'=>'serviceCardStatus_index'   ,'label'=>'لیست وضعیت کارت ها',   'group'=>'مدیریت وضعیت کارت ها' , 'mainGroup'=>'خدمات'],
            ['name'=>'serviceCardStatus_store'   ,'label'=>'ایجاد وضعیت کارت ها',  'group'=>'مدیریت وضعیت کارت ها' , 'mainGroup'=>'خدمات'],
            ['name'=>'serviceCardStatus_show'    ,'label'=>'نمایش وضعیت کارت ها',  'group'=>'مدیریت وضعیت کارت ها' , 'mainGroup'=>'خدمات'],
            ['name'=>'serviceCardStatus_update'  ,'label'=>'ویرایش وضعیت کارت ها', 'group'=>'مدیریت وضعیت کارت ها' , 'mainGroup'=>'خدمات'],
            ['name'=>'serviceCardStatus_destroy' ,'label'=>'حذف وضعیت کارت ها',    'group'=>'مدیریت وضعیت کارت ها' , 'mainGroup'=>'خدمات'],


            // skill

            ['name'=>'skill_index'   ,'label'=>'لیست مهارت ها',   'group'=>'مدیریت مهارت ها' , 'mainGroup'=>'مهارت ها'],
            ['name'=>'skill_store'   ,'label'=>'ایجاد مهارت ها',  'group'=>'مدیریت مهارت ها' , 'mainGroup'=>'مهارت ها'],
            ['name'=>'skill_show'    ,'label'=>'نمایش مهارت ها',  'group'=>'مدیریت مهارت ها' , 'mainGroup'=>'مهارت ها'],
            ['name'=>'skill_update'  ,'label'=>'ویرایش مهارت ها', 'group'=>'مدیریت مهارت ها' , 'mainGroup'=>'مهارت ها'],
            ['name'=>'skill_destroy' ,'label'=>'حذف مهارت ها',    'group'=>'مدیریت مهارت ها' , 'mainGroup'=>'مهارت ها'],


            ['name'=>'skillCategory_index'   ,'label'=>'لیست دسته بندی مهارت ها',   'group'=>'مدیریت دسته بندی مهارت ها' , 'mainGroup'=>'مهارت ها'],
            ['name'=>'skillCategory_store'   ,'label'=>'ایجاد دسته بندی مهارت ها',  'group'=>'مدیریت دسته بندی مهارت ها' , 'mainGroup'=>'مهارت ها'],
            ['name'=>'skillCategory_show'    ,'label'=>'نمایش دسته بندی مهارت ها',  'group'=>'مدیریت دسته بندی مهارت ها' , 'mainGroup'=>'مهارت ها'],
            ['name'=>'skillCategory_update'  ,'label'=>'ویرایش دسته بندی مهارت ها', 'group'=>'مدیریت دسته بندی مهارت ها' , 'mainGroup'=>'مهارت ها'],
            ['name'=>'skillCategory_destroy' ,'label'=>'حذف دسته بندی مهارت ها',    'group'=>'مدیریت دسته بندی مهارت ها' , 'mainGroup'=>'مهارت ها'],


            // skill

            ['name'=>'wallet_index'   ,'label'=>'لیست کیف پول',   'group'=>'مدیریت کیف پول' , 'mainGroup'=>'کیف پول'],
            ['name'=>'wallet_store'   ,'label'=>'ایجاد کیف پول',  'group'=>'مدیریت کیف پول' , 'mainGroup'=>'کیف پول'],
            ['name'=>'wallet_show'    ,'label'=>'نمایش کیف پول',  'group'=>'مدیریت کیف پول' , 'mainGroup'=>'کیف پول'],
            ['name'=>'wallet_update'  ,'label'=>'ویرایش کیف پول', 'group'=>'مدیریت کیف پول' , 'mainGroup'=>'کیف پول'],
            ['name'=>'wallet_destroy' ,'label'=>'حذف کیف پول',    'group'=>'مدیریت کیف پول' , 'mainGroup'=>'کیف پول'],

            ['name'=>'walletTransaction_index'   ,'label'=>'لیست تراکنش کیف پول',   'group'=>'مدیریت تراکنش کیف پول' , 'mainGroup'=>'کیف پول'],
            ['name'=>'walletTransaction_store'   ,'label'=>'ایجاد تراکنش کیف پول',  'group'=>'مدیریت تراکنش کیف پول' , 'mainGroup'=>'کیف پول'],
            ['name'=>'walletTransaction_show'    ,'label'=>'نمایش تراکنش کیف پول',  'group'=>'مدیریت تراکنش کیف پول' , 'mainGroup'=>'کیف پول'],
            ['name'=>'walletTransaction_update'  ,'label'=>'ویرایش تراکنش کیف پول', 'group'=>'مدیریت تراکنش کیف پول' , 'mainGroup'=>'کیف پول'],
            ['name'=>'walletTransaction_destroy' ,'label'=>'حذف تراکنش کیف پول',    'group'=>'مدیریت تراکنش کیف پول' , 'mainGroup'=>'کیف پول'],

            ['name'=>'walletRequest_index'   ,'label'=>'لیست تراکنش کیف پول',   'group'=>'مدیریت تراکنش کیف پول' , 'mainGroup'=>'کیف پول'],
            ['name'=>'walletRequest_store'   ,'label'=>'ایجاد تراکنش کیف پول',  'group'=>'مدیریت تراکنش کیف پول' , 'mainGroup'=>'کیف پول'],
            ['name'=>'walletRequest_show'    ,'label'=>'نمایش تراکنش کیف پول',  'group'=>'مدیریت تراکنش کیف پول' , 'mainGroup'=>'کیف پول'],
            ['name'=>'walletRequest_update'  ,'label'=>'ویرایش تراکنش کیف پول', 'group'=>'مدیریت تراکنش کیف پول' , 'mainGroup'=>'کیف پول'],
            ['name'=>'walletRequest_destroy' ,'label'=>'حذف تراکنش کیف پول',    'group'=>'مدیریت تراکنش کیف پول' , 'mainGroup'=>'کیف پول'],


            // Organization

            ['name'=>'organization_index'   ,'label'=>'لیست سازمان ها',   'group'=>'مدیریت سازمان ها' , 'mainGroup'=>'سازمان ها'],
            ['name'=>'organization_store'   ,'label'=>'ایجاد سازمان ها',  'group'=>'مدیریت سازمان ها' , 'mainGroup'=>'سازمان ها'],
            ['name'=>'organization_show'    ,'label'=>'نمایش سازمان ها',  'group'=>'مدیریت سازمان ها' , 'mainGroup'=>'سازمان ها'],
            ['name'=>'organization_update'  ,'label'=>'ویرایش سازمان ها', 'group'=>'مدیریت سازمان ها' , 'mainGroup'=>'سازمان ها'],
            ['name'=>'organization_destroy' ,'label'=>'حذف سازمان ها',    'group'=>'مدیریت سازمان ها' , 'mainGroup'=>'سازمان ها'],


            // Academy

            ['name'=>'agent_index'   ,'label'=>'لیست نمایندگی',   'group'=>'مدیریت نمایدگی' , 'mainGroup'=>'آکادمی'],
            ['name'=>'agent_store'   ,'label'=>'ایجاد نمایندگی',  'group'=>'مدیریت نمایدگی' , 'mainGroup'=>'آکادمی'],
            ['name'=>'agent_show'    ,'label'=>'نمایش نمایندگی',  'group'=>'مدیریت نمایدگی' , 'mainGroup'=>'آکادمی'],
            ['name'=>'agent_update'  ,'label'=>'ویرایش نمایندگی', 'group'=>'مدیریت نمایدگی' , 'mainGroup'=>'آکادمی'],
            ['name'=>'agent_destroy' ,'label'=>'حذف نمایندگی',    'group'=>'مدیریت نمایدگی' , 'mainGroup'=>'آکادمی'],

            ['name'=>'academy_index'   ,'label'=>'لیست آموزشگاه',   'group'=>'مدیریت آموزشگاه' , 'mainGroup'=>'آکادمی'],
            ['name'=>'academy_store'   ,'label'=>'ایجاد آموزشگاه',  'group'=>'مدیریت آموزشگاه' , 'mainGroup'=>'آکادمی'],
            ['name'=>'academy_show'    ,'label'=>'نمایش آموزشگاه',  'group'=>'مدیریت آموزشگاه' , 'mainGroup'=>'آکادمی'],
            ['name'=>'academy_update'  ,'label'=>'ویرایش آموزشگاه', 'group'=>'مدیریت آموزشگاه' , 'mainGroup'=>'آکادمی'],
            ['name'=>'academy_destroy' ,'label'=>'حذف آموزشگاه',    'group'=>'مدیریت آموزشگاه' , 'mainGroup'=>'آکادمی'],

            ['name'=>'academyType_index'   ,'label'=>'لیست آموزشگاه',   'group'=>'مدیریت آموزشگاه' , 'mainGroup'=>'آکادمی'],
            ['name'=>'academyType_store'   ,'label'=>'ایجاد آموزشگاه',  'group'=>'مدیریت آموزشگاه' , 'mainGroup'=>'آکادمی'],
            ['name'=>'academyType_show'    ,'label'=>'نمایش آموزشگاه',  'group'=>'مدیریت آموزشگاه' , 'mainGroup'=>'آکادمی'],
            ['name'=>'academyType_update'  ,'label'=>'ویرایش آموزشگاه', 'group'=>'مدیریت آموزشگاه' , 'mainGroup'=>'آکادمی'],
            ['name'=>'academyType_destroy' ,'label'=>'حذف آموزشگاه',    'group'=>'مدیریت آموزشگاه' , 'mainGroup'=>'آکادمی'],

            ['name'=>'student_index'   ,'label'=>'لیست دانشجو',   'group'=>'مدیریت دانشجو' , 'mainGroup'=>'آکادمی'],
            ['name'=>'student_store'   ,'label'=>'ایجاد دانشجو',  'group'=>'مدیریت دانشجو' , 'mainGroup'=>'آکادمی'],
            ['name'=>'student_show'    ,'label'=>'نمایش دانشجو',  'group'=>'مدیریت دانشجو' , 'mainGroup'=>'آکادمی'],
            ['name'=>'student_update'  ,'label'=>'ویرایش دانشجو', 'group'=>'مدیریت دانشجو' , 'mainGroup'=>'آکادمی'],
            ['name'=>'student_destroy' ,'label'=>'حذف دانشجو',    'group'=>'مدیریت دانشجو' , 'mainGroup'=>'آکادمی'],

        ];
        return $permissions;
    }

}
