<?php

use Carbon\Carbon;
use App\Models\Region\state;
use Illuminate\Database\Seeder;

class stateSeeder extends Seeder
{
    private $carbon;

    public function __construct()
    {
        $this->carbon = new Carbon();
    }

    public function run()
    {
        if (state::count() === 0) {
            state::insert($this->cats());
        }
    }

    public function cats()
    {
        $data = [
            ['title' => 'آذربایجان شرقی',      'country_id'=>114,  'order' => 1,   'latitude' => '46.26821090 37.90357330',  'created_at'=>$this->carbon->now()->subSecond(1)],
            ['title' => 'آذربایجان غربی',      'country_id'=>114,  'order' => 2,   'latitude' => '45.00000000 37.45500620',  'created_at'=>$this->carbon->now()->subSecond(2)],
            ['title' => 'اردبیل',              'country_id'=>114,  'order' => 3,   'latitude' => '47.89112090 38.48532760',  'created_at'=>$this->carbon->now()->subSecond(3)],
            ['title' => 'اصفهان',              'country_id'=>114,  'order' => 4,   'latitude' => '51.66798260 32.65462750',  'created_at'=>$this->carbon->now()->subSecond(4)],
            ['title' => 'البرز',               'country_id'=>114,  'order' => 5,   'latitude' => '50.92892460 35.99604670',  'created_at'=>$this->carbon->now()->subSecond(5)],
            ['title' => 'ایلام',                'country_id'=>114,  'order' => 6,   'latitude' => '46.67053400 33.29576180',  'created_at'=>$this->carbon->now()->subSecond(6)],
            ['title' => 'بوشهر',               'country_id'=>114,  'order' => 7,   'latitude' => '50.82031400 28.92338370',  'created_at'=>$this->carbon->now()->subSecond(7)],
            ['title' => 'تهران',               'country_id'=>114,  'order' => 8,   'latitude' => '51.42305600 35.69611100',  'created_at'=>$this->carbon->now()->subSecond(8)],
            ['title' => 'چهارمحال و بختیاری',  'country_id'=>114, 'order' => 9,   'latitude' => '50.84563230 31.96143480',  'created_at'=>$this->carbon->now()->subSecond(9)],
            ['title' => 'خراسان جنوبی',        'country_id'=>114, 'order' => 10,  'latitude' => '59.10417580 32.51756430',  'created_at'=>$this->carbon->now()->subSecond(10)],
            ['title' => 'خراسان رضوی',         'country_id'=>114, 'order' => 11,  'latitude' => '59.10417580 35.10202530',  'created_at'=>$this->carbon->now()->subSecond(11)],
            ['title' => 'خراسان شمالی',        'country_id'=>114, 'order' => 12,  'latitude' => '57.10131880 37.47103530',  'created_at'=>$this->carbon->now()->subSecond(12)],
            ['title' => 'خوزستان',             'country_id'=>114, 'order' => 13,  'latitude' => '49.04131200 31.43601490',  'created_at'=>$this->carbon->now()->subSecond(13)],
            ['title' => 'زنجان',               'country_id'=>114, 'order' => 14,  'latitude' => '48.39881860 36.50181850',  'created_at'=>$this->carbon->now()->subSecond(14)],
            ['title' => 'سمنان',               'country_id'=>114, 'order' => 15,  'latitude' => '54.43421380 35.22555850',  'created_at'=>$this->carbon->now()->subSecond(15)],
            ['title' => 'سیستان و بلوچستان',   'country_id'=>114, 'order' => 16,  'latitude' => '60.58206760,27.52999060',  'created_at'=>$this->carbon->now()->subSecond(16)],
            ['title' => 'فارس',                'country_id'=>114, 'order' => 17,  'latitude' => '53.04589300,29.10438130',  'created_at'=>$this->carbon->now()->subSecond(17)],
            ['title' => 'قزوین',               'country_id'=>114, 'order' => 18,  'latitude' => '49.85472660 36.08813170',  'created_at'=>$this->carbon->now()->subSecond(18)],
            ['title' => 'قم',                  'country_id'=>114, 'order' => 19,  'latitude' => '50.87594190 34.63994430',  'created_at'=>$this->carbon->now()->subSecond(19)],
            ['title' => 'كردستان',             'country_id'=>114, 'order' => 20,  'latitude' => '47.13621250 35.95535790',  'created_at'=>$this->carbon->now()->subSecond(20)],
            ['title' => 'كرمان',               'country_id'=>114, 'order' => 21,  'latitude' => '57.08336280 30.28393790',  'created_at'=>$this->carbon->now()->subSecond(21)],
            ['title' => 'كرمانشاه',            'country_id'=>114, 'order' => 22,  'latitude' => '47.06500000 34.31416700',  'created_at'=>$this->carbon->now()->subSecond(22)],
            ['title' => 'کهگیلویه و بویراحمد', 'country_id'=>114, 'order' => 23,  'latitude' => '51.60525000 30.65094790',  'created_at'=>$this->carbon->now()->subSecond(23)],
            ['title' => 'گلستان',               'country_id'=>114, 'order' => 24,  'latitude' => '55.13758340 37.28981230',  'created_at'=>$this->carbon->now()->subSecond(24)],
            ['title' => 'گیلان',                 'country_id'=>114, 'order' => 25,  'latitude' => '49.52799960 37.11716170',  'created_at'=>$this->carbon->now()->subSecond(25)],
            ['title' => 'لرستان',               'country_id'=>114, 'order' => 26,  'latitude' => '48.39881860 33.58183940',  'created_at'=>$this->carbon->now()->subSecond(26)],
            ['title' => 'مازندران',             'country_id'=>114, 'order' => 27,  'latitude' => '52.53186040 36.22623930',  'created_at'=>$this->carbon->now()->subSecond(27)],
            ['title' => 'مركزی',                'country_id'=>114, 'order' => 28,  'latitude' => '-92.39611900 33.50932940', 'created_at'=>$this->carbon->now()->subSecond(28)],
            ['title' => 'هرمزگان',              'country_id'=>114, 'order' => 29,  'latitude' => '55.13758340 27.13872300',  'created_at'=>$this->carbon->now()->subSecond(29)],
            ['title' => 'همدان',                'country_id'=>114, 'order' => 30,  'latitude' => '48.39881860 34.76079990',  'created_at'=>$this->carbon->now()->subSecond(30)],
            ['title' => 'یزد',                  'country_id'=>114, 'order' => 31,  'latitude' => '54.43421380 32.10063870',  'created_at'=>$this->carbon->now()->subSecond(31)],
        ];
        return $data;
    }
}
