<?php

use App\User;
use Carbon\Carbon;
use Illuminate\Database\Seeder;

class fakeUserSeeder extends Seeder
{
    public function run()
    {
        if (User::count() > 4) {
            return true;
        }
        $faker = \Faker\Factory::create('fa_IR');
        $user = [];
        for ($i = 0; $i < 100; $i++) {
            $user[] = [
                'email' => $i . $faker->email,
                'userName' => $i . $faker->userName,
                'firstName' => $faker->firstName(),
                'lastName' => $faker->lastName,
                'password' => '$2y$10$TKh8H1.PfQx37YgCzwiKb.KjNyWgaHb9cbcoQgdIVFlYg7B77UdFm',
                'remember_token' => str_random(10),
                'created_at' => Carbon::now()->subSecond($i),
                'updated_at' => Carbon::now()->subSecond($i),
            ];
        }
        User::insert($user);
    }
}
