@extends('admin.layout.master')

@section('content')
    <div class="row">
        <div class="col-md-12 ">
            <ol class="breadcrumb">
                <li><a href="{{route('admin.home')}}">داشبورد</a></li>
                <li class="active">آموزشگاه</li>
            </ol>
        </div>
    </div>

    <div class="row">
        <modal v-if="modal.destroy" @close="modal.destroy=false">
            <h3 style="margin:0" slot="header">آیا مایل به حدف هستید</h3>
            <div slot="body" class="row">
                <div class="col-md-12">
                    <div class="col-md-4">
                        <div class="col-md-12 blue-grey white-text pd5 z-depth-2 br4 text-center">شناسه</div>
                    </div>
                    <div class="col-md-8">
                        <div class="col-md-12 blue-grey white-text pd5 z-depth-2 br4 text-center" v-text="model.id"></div>
                    </div>
                    <div class="clearfix mb10"></div>
                    <div class="col-md-4">
                        <div class="col-md-12 blue-grey white-text pd5 z-depth-2 br4 text-center">مشخصات</div>
                    </div>
                    <div class="col-md-8">
                        <div class="col-md-12 blue-grey white-text pd5 z-depth-2 br4 text-center" v-text="model.title"></div>
                    </div>
                </div>
            </div>
            <div slot="footer">
                <a @click.prevent.default="Destroy" href="#!" class="waves-effect waves-green btn quarter">تایید</a>
                <a @click.prevent.default="modal.destroy=false" href="#!" class="waves-effect waves-green btn quarter blue-grey darken-2 left">انصراف</a>
            </div>
        </modal>
    </div>
    <div class="row white z-depth-1">
        <div class="col-md-12">
            <span class="blue-grey darken-3 white-text title percent-80 z-depth-2">آموزشگاه ها</span>
        </div>
        @can('agent_store')
            <div class="col-md-4 col-md-offset-4 mt10 text-center">
                <a :href="currentUrl+'create'" class="waves-effect full waves-light btn blue darken-1"><i class="material-icons left">add</i>ایجاد</a>
            </div>
        @endcan
        <div class="col-md-12 mt20">
            <div class="col-md-12">
                <div class="input-field">
                    <input id="query" name="query" type="text" class="validate" v-model="query">
                    <label for="query">جستجو</label>
                </div>
            </div>
        </div>

        <div class="col-md-12 pd4">
            <div class="table-responsive">
                <table class="table table-bordered table-hover white">
                    <thead class="blue-grey darken-2 white-text">
                    <tr>
                        <th @click="sort('orderby_id')">شناسه
                            <i v-if="params.orderby_id === 'asc'" class="fa fa-sort-amount-asc" aria-hidden="true"></i>
                            <i v-if="params.orderby_id === 'desc'" class="fa fa-sort-amount-desc" aria-hidden="true"></i>
                        </th>
                        <th @click="sort('orderby_title')">نام آموزشگاه
                            <i v-if="params.orderby_title === 'asc'" class="fa fa-sort-amount-asc" aria-hidden="true"></i>
                            <i v-if="params.orderby_title === 'desc'" class="fa fa-sort-amount-desc" aria-hidden="true"></i>
                        </th>
                        <th @click="sort('orderby_academy_count')">تعداد دانشجو
                            <i v-if="params.orderby_academy_count === 'asc'" class="fa fa-sort-amount-asc" aria-hidden="true"></i>
                            <i v-if="params.orderby_academy_count === 'desc'" class="fa fa-sort-amount-desc" aria-hidden="true"></i>
                        </th>
                        <th @click="sort('orderby_status')">وضعیت
                            <i v-if="params.orderby_status === 'asc'" class="fa fa-sort-amount-asc" aria-hidden="true"></i>
                            <i v-if="params.orderby_status === 'desc'" class="fa fa-sort-amount-desc" aria-hidden="true"></i>
                        </th>
                        <th>کد معرف</th>
                        <th>عملیات</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr v-for="item in itemList">
                        <td v-text="item.id"></td>
                        <td v-text="item.title"></td>
                        <td v-text="item.student_count"></td>
                        <td>
                            <i v-if="item.status" class="fa fa-check teal-text fa-lg" aria-hidden="true"></i>
                            <i v-else class="fa fa-times red-text fa-lg" aria-hidden="true"></i>
                        </td>
                        <td v-text="item.referalCode"></td>
                        <td>

                            @can('agent_update')
                                <a :href="currentUrl+item.id+'/edit'" class="btn-floating waves-effect waves-light blue"><i class="material-icons">edit</i></a>
                            @endcan

                            @can('agent_destroy')
                                <a href="#!" @click.prevent.default="callDestroy(item)" class="btn-floating waves-effect waves-light red mr20"><i class="material-icons">delete</i></a>
                            @endcan
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="col-md-12">
            <paginate v-if="itemList" v-model="itemList" :is-reset="reset" :url="currentUrl" :params="params"></paginate>
        </div>
    </div>
    <vue-toastr ref="toastr"></vue-toastr>
@endsection

@push('scripts')
    <script src="{{asset('assets/plugins/datePicker/moment.js')}}"></script>
    <script src="{{asset('assets/plugins/datePicker/moment-jalali.js')}}"></script>
    <script src="{{asset('assets/js/modal.js')}}"></script>
    <script src="{{asset('assets/js/paginator.js')}}"></script>
    <script src="{{asset('assets/js/vuetoaster.js')}}"></script>

    <script>
        new Vue({
            el: '#app',
            data: {
                currentUrl: location.pathname + '/',
                instance: axios.create({baseURL: location.pathname,}),
                itemList: [],
                reset: false,
                params: {},
                query: '',
                search: {
                    caseId: "",
                    nationalCode: "",
                    firstName: '',
                    lastName: '',
                    status: '',
                    accountNumber: '',
                    cardNumber: '',
                    date_start: '',
                    date_end: '',
                },
                modal: {
                    destroy: false
                },
                model: {
                    mode: 'create',
                    id: '',
                    title: '',
                    body: '',
                    destroy: []
                }
            },
            methods: {
                sort: function (query) {
                    this.reset = !this.reset;
                    if (this.changeSort(this.params[query]) === '') {
                        delete this.params[query];
                    } else {
                        this.params[query] = this.changeSort(this.params[query]);
                    }
                },
                changeSort: function (value) {
                    if (value === '' || value === undefined) {
                        return 'asc';
                    } else if (value === 'asc') {
                        return 'desc'
                    } else {
                        return ''
                    }
                },
                callDestroy: function (item) {
                    this.model.id = item.id;
                    this.model.title = item.title;

                    this.modal.destroy = true;
                },
                Destroy: function () {
                    var id = this.model.id;
                    this.instance.delete('/' + id, {}).then(function (response) {
                        this.reset = !this.reset;
                        this.modal.destroy = false;
                        this.$refs.toastr.defaultPosition = "toast-bottom-left";
                        this.$refs.toastr.s("حذف شد");
                    }.bind(this));
                },

                toPersian: function (input) {
                    return moment(input, 'YYYY/MM/DD HH:mm:ss').format('jYYYY/jMM/jDD');
                }
            },
            computed: {
                isEdit: function () {
                    return (this.model.mode === 'edit');
                },
                isDestroy: function () {
                    return (this.model.mode === 'destroy');
                },
            },
            watch: {
                query: function () {
                    this.params.query = this.query;
                    this.reset = !this.reset;
                },
            },
            components: {
                'vue-toastr': window.vueToastr,
            }
        });

    </script>
@endpush

@push('styles')
    <link rel="stylesheet" href="{{asset('assets/plugins/datePicker/persianDatePicker.css')}}" />
    <link rel="stylesheet" href="{{asset('assets/plugins/datePicker/custom.css')}}" />
@endpush
