@extends('admin.layout.master')

@section('content')
    <div class="row">
        <div class="col-md-12 ">
            <ol class="breadcrumb">
                <li><a href="{{route('admin.home')}}">صفحه اصلی</a></li>
                <li><a href="{{route('admin.service.card.index')}}">لیست کارت ها</a></li>
                <li class="active">ایجاد کارت ها</li>
            </ol>
        </div>
    </div>

    <form method="post" action="{{route('admin.service.card.update',$serviceCard->id)}}">
        {{ method_field('PUT') }}
        {{ csrf_field() }}
        <div class="row white z-depth-1">
            <div class="col-md-12">
                <span class="blue-grey darken-2 white-text title z-depth-2">ویرایش کارت</span>
                @include('share.extra.back2',['route'=>route('admin.service.card.index')])
            </div>

            <div class="col-md-6">
                @include('share.forms.input',['name'=>'title','title'=>'تیتر','value'=>$serviceCard->title])
            </div>
            <div class="col-md-6">
                @include('share.forms.input',['name'=>'price','class'=>'dleft price','title'=>'مبلغ (تومان)','value'=>$serviceCard->price])
            </div>
            <div class="clearfix"></div>
            <div class="col-md-6">
                @include('share.forms.switch',['name'=>'status','title'=>'فعال','checked'=>$serviceCard->status])
            </div>


            <div class="col-md-12 mb20 mt20 ">
                <button class="waves-effect waves-light btn quarter center-block blue-grey darken-2">ذخیره</button>
            </div>

        </div>
    </form>
@endsection


@push('scripts')
    <script src="{{asset('assets/plugins/number/jquery.number.min.js')}}"></script>

    <script type="text/javascript">
        $(document).ready(function () {
            $('.price').number(true);
        });
    </script>
@endpush
